/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage.domain;

import com.google.common.collect.ForwardingList;
import java.beans.ConstructorProperties;
import java.util.List;
import org.jclouds.googlecloud.domain.ListPage;
import org.jclouds.googlecloud.internal.NullSafeCopies;
import org.jclouds.javax.annotation.Nullable;

public final class ListPageWithPrefixes<T>
extends ForwardingList<T>
implements ListPage<T> {
    private final List<T> items;
    private final String nextPageToken;
    private final List<String> prefixes;

    public static <T> ListPageWithPrefixes<T> create(List<T> items, String nextPageToken, List<String> prefixes) {
        return new ListPageWithPrefixes<T>(items, nextPageToken, prefixes);
    }

    @ConstructorProperties(value={"items", "nextPageToken", "prefixes"})
    public ListPageWithPrefixes(List<T> items, String nextPageToken, List<String> prefixes) {
        this.items = NullSafeCopies.copyOf(items);
        this.nextPageToken = nextPageToken;
        this.prefixes = NullSafeCopies.copyOf(prefixes);
    }

    @Override
    @Nullable
    public String nextPageToken() {
        return this.nextPageToken;
    }

    public List<String> prefixes() {
        return this.prefixes;
    }

    @Override
    protected List<T> delegate() {
        return this.items;
    }
}

