/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.beans.ConstructorProperties;

public class BillingToken
implements Comparable<BillingToken> {
    private final long id;
    private final String name;
    private final double price;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromBillingToken(this);
    }

    @ConstructorProperties(value={"id", "name", "price"})
    protected BillingToken(long id, String name, double price) {
        this.id = id;
        this.name = Preconditions.checkNotNull(name, "name");
        this.price = price;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public double getPrice() {
        return this.price;
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.name, this.price);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BillingToken that = (BillingToken)BillingToken.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.name, that.name) && Objects.equal(this.price, that.price);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("name", this.name).add("price", this.price);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(BillingToken o) {
        return Longs.compare(this.id, o.getId());
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected long id;
        protected String name;
        protected double price;

        protected abstract T self();

        public T id(long id) {
            this.id = id;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T price(double price) {
            this.price = price;
            return this.self();
        }

        public BillingToken build() {
            return new BillingToken(this.id, this.name, this.price);
        }

        public T fromBillingToken(BillingToken in) {
            return ((Builder)((Builder)this.id(in.getId())).name(in.getName())).price(in.getPrice());
        }
    }
}

