/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.compute.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.functions.IdentityFunction;
import org.jclouds.gogrid.compute.functions.OptionToLocation;
import org.jclouds.gogrid.compute.functions.ServerImageToImage;
import org.jclouds.gogrid.compute.functions.ServerToNodeMetadata;
import org.jclouds.gogrid.compute.options.GoGridTemplateOptions;
import org.jclouds.gogrid.compute.strategy.GoGridComputeServiceAdapter;
import org.jclouds.gogrid.domain.Option;
import org.jclouds.gogrid.domain.Server;
import org.jclouds.gogrid.domain.ServerImage;
import org.jclouds.gogrid.domain.ServerImageState;
import org.jclouds.gogrid.domain.ServerState;

public class GoGridComputeServiceContextModule
extends ComputeServiceAdapterContextModule<Server, Hardware, ServerImage, Option> {
    @VisibleForTesting
    static final Map<ServerState, NodeMetadata.Status> toPortableNodeStatus = ImmutableMap.builder().put(ServerState.ON, NodeMetadata.Status.RUNNING).put(ServerState.STARTING, NodeMetadata.Status.PENDING).put(ServerState.OFF, NodeMetadata.Status.SUSPENDED).put(ServerState.STOPPING, NodeMetadata.Status.PENDING).put(ServerState.RESTARTING, NodeMetadata.Status.PENDING).put(ServerState.SAVING, NodeMetadata.Status.PENDING).put(ServerState.UNRECOGNIZED, NodeMetadata.Status.UNRECOGNIZED).put(ServerState.RESTORING, NodeMetadata.Status.PENDING).put(ServerState.UPDATING, NodeMetadata.Status.PENDING).build();
    @VisibleForTesting
    static final Map<ServerImageState, Image.Status> toPortableImageStatus = ImmutableMap.builder().put(ServerImageState.AVAILABLE, Image.Status.AVAILABLE).put(ServerImageState.SAVING, Image.Status.PENDING).put(ServerImageState.TRASH, Image.Status.DELETED).put(ServerImageState.UNRECOGNIZED, Image.Status.UNRECOGNIZED).build();

    @Override
    protected void configure() {
        super.configure();
        this.bind(new TypeLiteral<ComputeServiceAdapter<Server, Hardware, ServerImage, Option>>(){}).to(GoGridComputeServiceAdapter.class);
        this.bind(new TypeLiteral<Function<Server, NodeMetadata>>(){}).to(ServerToNodeMetadata.class);
        this.bind(new TypeLiteral<Function<ServerImage, Image>>(){}).to(ServerImageToImage.class);
        this.bind(new TypeLiteral<Function<Option, Location>>(){}).to(OptionToLocation.class);
        this.bind(new TypeLiteral<Function<Hardware, Hardware>>(){}).to((Class)Class.class.cast(IdentityFunction.class));
        this.bind(TemplateOptions.class).to(GoGridTemplateOptions.class);
        this.install(new ComputeServiceAdapterContextModule.LocationsFromComputeServiceAdapterModule<Server, Hardware, ServerImage, Option>(){});
    }

    @Singleton
    @Provides
    final Map<ServerState, NodeMetadata.Status> toPortableNodeStatus() {
        return toPortableNodeStatus;
    }

    @Singleton
    @Provides
    final Map<ServerImageState, Image.Status> toPortableImageStatus() {
        return toPortableImageStatus;
    }

    @Singleton
    @Provides
    final Function<Hardware, String> provideSizeToRam() {
        return new Function<Hardware, String>(){

            @Override
            public String apply(Hardware hardware) {
                if (hardware.getRam() >= 8192 || ComputeServiceUtils.getCores(hardware) >= 6.0 || ComputeServiceUtils.getSpace(hardware) >= 450.0) {
                    return "8GB";
                }
                if (hardware.getRam() >= 4096 || ComputeServiceUtils.getCores(hardware) >= 3.0 || ComputeServiceUtils.getSpace(hardware) >= 230.0) {
                    return "4GB";
                }
                if (hardware.getRam() >= 2048 || ComputeServiceUtils.getSpace(hardware) >= 110.0) {
                    return "2GB";
                }
                if (hardware.getRam() >= 1024 || ComputeServiceUtils.getSpace(hardware) >= 55.0) {
                    return "1GB";
                }
                return "512MB";
            }
        };
    }
}

