/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.predicates.validators;

import com.google.common.base.Preconditions;
import com.google.inject.Singleton;
import org.jclouds.io.Payload;
import org.jclouds.predicates.Validator;

@Singleton
public final class PayloadValidator
extends Validator<Payload> {
    private static final long MAX_CONTENT_SIZE = 0x100000000L;

    @Override
    public void validate(Payload payload) {
        Preconditions.checkNotNull(payload, "Archive must have a payload.");
        Preconditions.checkNotNull(payload.getContentMetadata().getContentLength(), "Content length must be set.");
        Preconditions.checkArgument(payload.getContentMetadata().getContentLength() <= 0x100000000L, "Max content size is 4gb but was %s", (Object)payload.getContentMetadata().getContentLength());
    }
}

