/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.blobstore.strategy.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.strategy.ClearListStrategy;
import org.jclouds.glacier.GlacierClient;
import org.jclouds.glacier.blobstore.strategy.PollingStrategy;
import org.jclouds.glacier.domain.ArchiveMetadata;
import org.jclouds.glacier.domain.ArchiveMetadataCollection;
import org.jclouds.glacier.domain.InventoryRetrievalJobRequest;
import org.jclouds.rest.ResourceNotFoundException;

@Singleton
public class ClearVaultStrategy
implements ClearListStrategy {
    private final GlacierClient client;
    private final PollingStrategy pollingStrategy;

    @Inject
    public ClearVaultStrategy(GlacierClient client, PollingStrategy pollingStrategy) {
        this.client = Preconditions.checkNotNull(client, "client");
        this.pollingStrategy = Preconditions.checkNotNull(pollingStrategy, "pollingStrategy");
    }

    @Override
    public void execute(String container, ListContainerOptions listContainerOptions) {
        String jobId = this.client.initiateJob(container, InventoryRetrievalJobRequest.builder().build());
        try {
            if (this.pollingStrategy.waitForSuccess(container, jobId)) {
                ArchiveMetadataCollection archives = this.client.getInventoryRetrievalOutput(container, jobId);
                for (ArchiveMetadata archive : archives) {
                    try {
                        this.client.deleteArchive(container, archive.getArchiveId());
                    }
                    catch (ResourceNotFoundException resourceNotFoundException) {}
                }
            }
        }
        catch (InterruptedException e) {
            Throwables.propagate(e);
        }
    }
}

