/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;
import org.jclouds.util.Maps2;

public class IpPermissions
extends IpPermission {
    protected IpPermissions(IpProtocol ipProtocol, int fromPort, int toPort, Multimap<String, String> userIdGroupPairs, Iterable<String> groupIds, Iterable<String> ipRanges) {
        super(ipProtocol, fromPort, toPort, userIdGroupPairs, groupIds, userIdGroupPairs.isEmpty() ? ipRanges : ImmutableSet.of(), ImmutableSet.of());
    }

    @Beta
    public static Multimap<String, String> buildFormParametersForIndex(final int index, IpPermission permission) {
        LinkedHashMap<String, String> headers = Maps.newLinkedHashMap();
        headers.put("IpPermissions.%d.IpProtocol", permission.getIpProtocol().toString());
        headers.put("IpPermissions.%d.FromPort", permission.getFromPort() + "");
        headers.put("IpPermissions.%d.ToPort", permission.getToPort() + "");
        String prefix = "IpPermissions.%d.IpRanges.";
        int i = 0;
        for (String string : Preconditions.checkNotNull(permission.getCidrBlocks(), "cidrIps")) {
            headers.put(prefix + i++ + ".CidrIp", string);
        }
        prefix = "IpPermissions.%d.Groups.";
        i = 0;
        for (String string : Preconditions.checkNotNull(permission.getGroupIds(), "groupIds")) {
            headers.put(prefix + i++ + ".GroupId", string);
        }
        prefix = "IpPermissions.%d.Groups.";
        i = 0;
        for (Map.Entry entry : Preconditions.checkNotNull(permission.getTenantIdGroupNamePairs(), "tenantIdGroupNamePairs").entries()) {
            headers.put(prefix + i + ".UserId", (String)entry.getKey());
            headers.put(prefix + i + ".GroupId", (String)entry.getValue());
            ++i;
        }
        prefix = "IpPermissions.%d.IpRanges.";
        i = 0;
        for (String string : Preconditions.checkNotNull(permission.getCidrBlocks(), "cidrIps")) {
            headers.put(prefix + i++ + ".CidrIp", string);
        }
        return Multimaps.forMap(Maps2.transformKeys(headers, new Function<String, String>(){

            @Override
            public String apply(String arg0) {
                return String.format(arg0, index);
            }
        }));
    }

    public static ICMPTypeSelection permitICMP() {
        return new ICMPTypeSelection();
    }

    public static ToSourceSelection permitAnyProtocol() {
        return new ToSourceSelection(IpProtocol.ALL, 1, 65535);
    }

    public static PortSelection permit(IpProtocol protocol) {
        return new PortSelection(Preconditions.checkNotNull(protocol, "protocol"));
    }

    public static class ToSourceSelection
    extends ToVPCSourceSelection {
        ToSourceSelection(IpProtocol ipProtocol, int fromPort, int toPort) {
            super(ipProtocol, fromPort, toPort);
        }

        public IpPermissions originatingFromCidrBlock(String cidrIp) {
            return this.originatingFromCidrBlocks(ImmutableSet.of(Preconditions.checkNotNull(cidrIp, "cidrIp")));
        }

        public IpPermissions originatingFromCidrBlocks(Iterable<String> cidrIps) {
            return new IpPermissions(this.getIpProtocol(), this.getFromPort(), this.getToPort(), ImmutableMultimap.of(), ImmutableSet.of(), cidrIps);
        }

        public IpPermissions originatingFromUserAndSecurityGroup(String userId, String groupName) {
            return this.toEC2SecurityGroups(ImmutableMultimap.of(Preconditions.checkNotNull(userId, "userId"), Preconditions.checkNotNull(groupName, "groupName")));
        }

        public IpPermissions toEC2SecurityGroups(Multimap<String, String> tenantIdGroupNamePairs) {
            return new IpPermissions(this.getIpProtocol(), this.getFromPort(), this.getToPort(), tenantIdGroupNamePairs, this.getGroupIds(), ImmutableSet.of());
        }
    }

    public static class ToVPCSourceSelection
    extends IpPermissions {
        protected ToVPCSourceSelection(IpProtocol ipProtocol, int fromPort, int toPort) {
            super(ipProtocol, fromPort, toPort, ImmutableMultimap.of(), ImmutableSet.of(), ImmutableSet.of("0.0.0.0/0"));
        }

        public IpPermissions originatingFromSecurityGroupId(String groupId) {
            return this.toVPCSecurityGroups(ImmutableSet.of(Preconditions.checkNotNull(groupId, "groupId")));
        }

        public IpPermissions toVPCSecurityGroups(Iterable<String> groupIds) {
            return new IpPermissions(this.getIpProtocol(), this.getFromPort(), this.getToPort(), this.getTenantIdGroupNamePairs(), groupIds, ImmutableSet.of());
        }
    }

    public static class ToPortSelection
    extends ToSourceSelection {
        ToPortSelection(IpProtocol ipProtocol, int fromPort) {
            super(ipProtocol, fromPort, ipProtocol == IpProtocol.ICMP ? -1 : 65535);
        }

        public ToSourceSelection to(int port) {
            return new ToSourceSelection(this.getIpProtocol(), this.getFromPort(), port);
        }
    }

    public static class PortSelection
    extends ToSourceSelection {
        PortSelection(IpProtocol ipProtocol) {
            super(ipProtocol, ipProtocol == IpProtocol.ICMP ? -1 : 1, ipProtocol == IpProtocol.ICMP ? -1 : 65535);
        }

        public ToPortSelection fromPort(int port) {
            return new ToPortSelection(this.getIpProtocol(), port);
        }

        public ToSourceSelection port(int port) {
            return new ToSourceSelection(this.getIpProtocol(), port, port);
        }
    }

    public static class AndCodeSelection
    extends ToSourceSelection {
        AndCodeSelection(int type) {
            super(IpProtocol.ICMP, type, -1);
        }

        public ToSourceSelection andCode(int code) {
            return new ToSourceSelection(this.getIpProtocol(), this.getFromPort(), code);
        }
    }

    public static class ICMPTypeSelection
    extends ToSourceSelection {
        ICMPTypeSelection() {
            super(IpProtocol.ICMP, -1, -1);
        }

        public AndCodeSelection type(int type) {
            return new AndCodeSelection(type);
        }
    }
}

