/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.functions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.Atomics;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.compute.domain.PasswordDataAndPrivateKey;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.ec2.domain.PasswordData;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.ec2.features.WindowsApi;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.logging.Logger;
import org.jclouds.util.Predicates2;

@Singleton
public class PasswordCredentialsFromWindowsInstance
implements Function<RunningInstance, LoginCredentials> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final ConcurrentMap<RegionAndName, KeyPair> credentialsMap;
    private final EC2Api ec2Api;
    private final Function<PasswordDataAndPrivateKey, LoginCredentials> pwDataToLoginCredentials;

    @Inject
    protected PasswordCredentialsFromWindowsInstance(ConcurrentMap<RegionAndName, KeyPair> credentialsMap, EC2Api ec2Api, Function<PasswordDataAndPrivateKey, LoginCredentials> pwDataToLoginCredentials) {
        this.credentialsMap = Preconditions.checkNotNull(credentialsMap, "credentialsMap");
        this.ec2Api = Preconditions.checkNotNull(ec2Api, "ec2Api");
        this.pwDataToLoginCredentials = Preconditions.checkNotNull(pwDataToLoginCredentials, "pwDataToLoginCredentials");
    }

    @Override
    public LoginCredentials apply(final RunningInstance instance) {
        Optional<? extends WindowsApi> windowsOption = this.ec2Api.getWindowsApiForRegion(instance.getRegion());
        Preconditions.checkState(windowsOption.isPresent(), "windows feature not present in region %s", (Object)instance.getRegion());
        final WindowsApi windowsApi = windowsOption.get();
        LoginCredentials credentials = LoginCredentials.builder().user("Administrator").noPrivateKey().build();
        String privateKey = this.getPrivateKeyOrNull(instance);
        if (privateKey == null) {
            return credentials;
        }
        final AtomicReference data = Atomics.newReference();
        Predicate<String> passwordReady = new Predicate<String>(){

            @Override
            public boolean apply(@Nullable String s2) {
                if (Strings.isNullOrEmpty(s2)) {
                    return false;
                }
                data.set(windowsApi.getPasswordDataForInstance(instance.getId()));
                if (data.get() == null) {
                    return false;
                }
                return !Strings.isNullOrEmpty(((PasswordData)data.get()).getPasswordData());
            }
        };
        Predicate<String> passwordReadyRetryable = Predicates2.retry(passwordReady, 600L, 10L, TimeUnit.SECONDS);
        this.logger.debug(">> awaiting password data for instance(%s/%s)", instance.getRegion(), instance.getId());
        if (passwordReadyRetryable.apply(instance.getId())) {
            credentials = this.pwDataToLoginCredentials.apply(new PasswordDataAndPrivateKey((PasswordData)data.get(), privateKey));
            this.logger.debug("<< obtained password data for instance(%s/%s)", instance.getRegion(), instance.getId());
        } else {
            this.logger.debug("<< unable to get password data for instance(%s/%s)", instance.getRegion(), instance.getId());
        }
        return credentials;
    }

    @VisibleForTesting
    String getPrivateKeyOrNull(RunningInstance instance) {
        KeyPair keyPair = (KeyPair)this.credentialsMap.get(new RegionAndName(instance.getRegion(), instance.getKeyName()));
        return keyPair != null ? keyPair.getKeyMaterial() : null;
    }
}

