/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Map;
import javax.inject.Named;
import org.jclouds.dynect.v3.domain.RecordId;

public class Record<D extends Map<String, Object>>
extends RecordId {
    private final int ttl;
    @Named(value="rdata")
    private final D rdata;

    @ConstructorProperties(value={"zone", "fqdn", "record_type", "record_id", "ttl", "rdata"})
    protected Record(String zone, String fqdn, String type, long id, int ttl, D rdata) {
        super(zone, fqdn, type, id);
        Preconditions.checkArgument(ttl >= 0, "ttl of %s must be unsigned", (Object)fqdn);
        this.ttl = ttl;
        this.rdata = (Map)Preconditions.checkNotNull(rdata, "rdata of %s", id);
    }

    public int getTTL() {
        return this.ttl;
    }

    public D getRData() {
        return this.rdata;
    }

    @Override
    protected MoreObjects.ToStringHelper string() {
        return super.string().add("ttl", this.ttl).add("rdata", this.rdata);
    }

    public static <D extends Map<String, Object>> Builder<D, ?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<D, ?> toBuilder() {
        return new ConcreteBuilder().from(this);
    }

    private static class ConcreteBuilder<D extends Map<String, Object>>
    extends Builder<D, ConcreteBuilder<D>> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder<D> self() {
            return this;
        }
    }

    public static abstract class Builder<D extends Map<String, Object>, B extends Builder<D, B>>
    extends RecordId.Builder<B> {
        protected int ttl = -1;
        protected D rdata;

        public B ttl(int ttl) {
            this.ttl = ttl;
            return (B)((Builder)this.self());
        }

        public B rdata(D rdata) {
            this.rdata = rdata;
            return (B)((Builder)this.self());
        }

        @Override
        public Record<D> build() {
            return new Record<D>(this.zone, this.fqdn, this.type, this.id, this.ttl, this.rdata);
        }

        @Override
        public B from(RecordId in) {
            if (in instanceof Record) {
                Record record = (Record)Record.class.cast(in);
                ((Builder)this.ttl(record.ttl)).rdata((Map)record.rdata);
            }
            return (B)((Builder)super.from(in));
        }
    }
}

