/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import javax.inject.Singleton;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.digitalocean2.domain.Droplet;

@Singleton
public class DropletStatusToStatus
implements Function<Droplet.Status, NodeMetadata.Status> {
    private static final Function<Droplet.Status, NodeMetadata.Status> toPortableStatus = Functions.forMap(ImmutableMap.builder().put(Droplet.Status.NEW, NodeMetadata.Status.PENDING).put(Droplet.Status.ACTIVE, NodeMetadata.Status.RUNNING).put(Droplet.Status.ARCHIVE, NodeMetadata.Status.TERMINATED).put(Droplet.Status.OFF, NodeMetadata.Status.SUSPENDED).build(), NodeMetadata.Status.UNRECOGNIZED);

    @Override
    public NodeMetadata.Status apply(Droplet.Status input) {
        return toPortableStatus.apply(input);
    }
}

