/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.xml;

import com.google.common.annotations.Beta;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Set;
import org.jclouds.cloudwatch.domain.AlarmHistoryItem;
import org.jclouds.cloudwatch.xml.AlarmHistoryItemHandler;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.IterableWithMarkers;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

@Beta
public class ListAlarmHistoryResponseHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<IterableWithMarker<AlarmHistoryItem>> {
    private final AlarmHistoryItemHandler alarmHistoryItemHandler;
    private StringBuilder currentText = new StringBuilder();
    private Set<AlarmHistoryItem> alarmHistoryItems = Sets.newLinkedHashSet();
    private String nextToken;
    private boolean inAlarmHistoryItems;

    @Inject
    public ListAlarmHistoryResponseHandler(AlarmHistoryItemHandler alarmHistoryItemHandler) {
        this.alarmHistoryItemHandler = alarmHistoryItemHandler;
    }

    @Override
    public void startElement(String url, String name, String qName, Attributes attributes) throws SAXException {
        if (SaxUtils.equalsOrSuffix(qName, "AlarmHistoryItems")) {
            this.inAlarmHistoryItems = true;
        }
        if (this.inAlarmHistoryItems) {
            this.alarmHistoryItemHandler.startElement(url, name, qName, attributes);
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) throws SAXException {
        if (this.inAlarmHistoryItems) {
            if (qName.equals("AlarmHistoryItems")) {
                this.inAlarmHistoryItems = false;
            } else if (qName.equals("member")) {
                this.alarmHistoryItems.add(this.alarmHistoryItemHandler.getResult());
            } else {
                this.alarmHistoryItemHandler.endElement(uri, name, qName);
            }
        } else if (qName.equals("NextToken")) {
            this.nextToken = SaxUtils.currentOrNull(this.currentText);
        }
        this.currentText.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.inAlarmHistoryItems) {
            this.alarmHistoryItemHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }

    @Override
    public IterableWithMarker<AlarmHistoryItem> getResult() {
        IterableWithMarker<AlarmHistoryItem> result = IterableWithMarkers.from(this.alarmHistoryItems, this.nextToken);
        this.alarmHistoryItems = Sets.newLinkedHashSet();
        this.nextToken = null;
        return result;
    }
}

