/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.options;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Set;
import org.jclouds.cloudwatch.domain.Dimension;
import org.jclouds.cloudwatch.domain.Statistics;
import org.jclouds.cloudwatch.domain.Unit;
import org.jclouds.http.options.BaseHttpRequestOptions;

@Beta
public class ListAlarmsForMetric
extends BaseHttpRequestOptions {
    int dimensionIndex = 1;

    public ListAlarmsForMetric dimensions(Set<Dimension> dimensions) {
        for (Dimension dimension : Preconditions.checkNotNull(dimensions, "dimensions")) {
            this.dimension(dimension);
        }
        return this;
    }

    public ListAlarmsForMetric dimension(Dimension dimension) {
        Preconditions.checkNotNull(dimension, "dimension");
        Preconditions.checkArgument(this.dimensionIndex <= 10, "maximum number of dimensions is 10");
        this.formParameters.put("Dimensions.member." + this.dimensionIndex + ".Name", dimension.getName());
        this.formParameters.put("Dimensions.member." + this.dimensionIndex + ".Value", dimension.getValue());
        ++this.dimensionIndex;
        return this;
    }

    public ListAlarmsForMetric metricName(String metricName) {
        Preconditions.checkNotNull(metricName, "metricName");
        Preconditions.checkArgument(metricName.length() <= 255, "metricName must be between 1 and 255 characters in length");
        this.formParameters.put("MetricName", metricName);
        return this;
    }

    public ListAlarmsForMetric namespace(String namespace) {
        Preconditions.checkNotNull(namespace, "namespace");
        Preconditions.checkArgument(namespace.length() <= 255, "namespace must be between 1 and 255 characters in length");
        this.formParameters.put("Namespace", namespace);
        return this;
    }

    public ListAlarmsForMetric period(int period) {
        this.formParameters.put("Period", String.valueOf(period));
        return this;
    }

    public ListAlarmsForMetric statistic(Statistics statistic) {
        Preconditions.checkNotNull(statistic, "statistic");
        Preconditions.checkArgument(statistic != Statistics.UNRECOGNIZED, "statistic unrecognized");
        this.formParameters.put("Statistic", statistic.toString());
        return this;
    }

    public ListAlarmsForMetric unit(Unit unit) {
        Preconditions.checkNotNull(unit, "unit");
        Preconditions.checkArgument(unit != Unit.UNRECOGNIZED, "unit unrecognized");
        this.formParameters.put("Unit", unit.toString());
        return this;
    }
}

