/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Preconditions;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cloudstack.CloudStackApi;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.FirewallRule;
import org.jclouds.cloudstack.domain.PublicIPAddress;
import org.jclouds.cloudstack.options.CreateFirewallRuleOptions;
import org.jclouds.cloudstack.strategy.BlockUntilJobCompletesAndReturnResult;
import org.jclouds.logging.Logger;

@Singleton
public class CreateFirewallRulesForIP {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final CloudStackApi client;
    private final BlockUntilJobCompletesAndReturnResult blockUntilJobCompletesAndReturnResult;
    private final LoadingCache<String, Set<FirewallRule>> getFirewallRulesByVirtualMachine;

    @Inject
    public CreateFirewallRulesForIP(CloudStackApi client, BlockUntilJobCompletesAndReturnResult blockUntilJobCompletesAndReturnResult, LoadingCache<String, Set<FirewallRule>> getFirewallRulesByVirtualMachine) {
        this.client = Preconditions.checkNotNull(client, "client");
        this.blockUntilJobCompletesAndReturnResult = Preconditions.checkNotNull(blockUntilJobCompletesAndReturnResult, "blockUntilJobCompletesAndReturnResult");
        this.getFirewallRulesByVirtualMachine = Preconditions.checkNotNull(getFirewallRulesByVirtualMachine, "getFirewallRulesByVirtualMachine");
    }

    public Set<FirewallRule> apply(PublicIPAddress ip, Iterable<Integer> ports) {
        return this.apply(ip, "tcp", ports);
    }

    public Set<FirewallRule> apply(PublicIPAddress ip, String protocol, Iterable<Integer> ports) {
        Preconditions.checkState(ip.getVirtualMachineId() != null, "ip %s should be static NATed to a virtual machine before applying rules", (Object)ip);
        if (Iterables.isEmpty(ports)) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder responses = ImmutableSet.builder();
        for (int port : ports) {
            AsyncCreateResponse response = this.client.getFirewallApi().createFirewallRuleForIpAndProtocol(ip.getId(), FirewallRule.Protocol.fromValue(protocol), CreateFirewallRuleOptions.Builder.startPort(port).endPort(port));
            this.logger.debug(">> creating firewall rule IPAddress(%s) for protocol(%s), port(%s); response(%s)", ip.getId(), protocol, port, response);
            responses.add(response);
        }
        ImmutableSet.Builder rules = ImmutableSet.builder();
        for (AsyncCreateResponse response : responses.build()) {
            FirewallRule rule = (FirewallRule)this.blockUntilJobCompletesAndReturnResult.apply(response);
            rules.add(rule);
            this.getFirewallRulesByVirtualMachine.asMap().put(ip.getVirtualMachineId(), ImmutableSet.of(rule));
        }
        return rules.build();
    }
}

