/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import org.jclouds.cloudstack.domain.Account;
import org.jclouds.javax.annotation.Nullable;

public class LoginResponse {
    private final String username;
    private final String userId;
    private final String password;
    private final String domainId;
    private final long timeout;
    private final boolean registered;
    private final String accountName;
    private final String firstName;
    private final String lastName;
    private final Account.Type accountType;
    private final String timezone;
    private final String timezoneOffset;
    private final String sessionKey;
    private final String jSessionId;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromLoginResponse(this);
    }

    @ConstructorProperties(value={"username", "userid", "password", "domainid", "timeout", "registered", "account", "firstname", "lastname", "type", "timezone", "timezoneoffset", "sessionkey", "jSessionId"})
    protected LoginResponse(@Nullable String username, @Nullable String userId, @Nullable String password, @Nullable String domainId, long timeout, boolean registered, @Nullable String accountName, @Nullable String firstName, @Nullable String lastName, @Nullable Account.Type accountType, @Nullable String timezone, @Nullable String timezoneOffset, @Nullable String sessionKey, @Nullable String jSessionId) {
        this.username = username;
        this.userId = userId;
        this.password = password;
        this.domainId = domainId;
        this.timeout = timeout;
        this.registered = registered;
        this.accountName = accountName;
        this.firstName = firstName;
        this.lastName = lastName;
        this.accountType = accountType;
        this.timezone = timezone;
        this.timezoneOffset = timezoneOffset;
        this.sessionKey = sessionKey;
        this.jSessionId = jSessionId;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getUserId() {
        return this.userId;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    @Nullable
    public String getDomainId() {
        return this.domainId;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    @Nullable
    public String getAccountName() {
        return this.accountName;
    }

    @Nullable
    public String getFirstName() {
        return this.firstName;
    }

    @Nullable
    public String getLastName() {
        return this.lastName;
    }

    @Nullable
    public Account.Type getAccountType() {
        return this.accountType;
    }

    @Nullable
    public String getTimezone() {
        return this.timezone;
    }

    @Nullable
    public String getTimezoneOffset() {
        return this.timezoneOffset;
    }

    @Nullable
    public String getSessionKey() {
        return this.sessionKey;
    }

    @Nullable
    public String getJSessionId() {
        return this.jSessionId;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.username, this.userId, this.password, this.domainId, this.timeout, this.registered, this.accountName, this.firstName, this.lastName, this.accountType, this.timezone, this.timezoneOffset, this.sessionKey, this.jSessionId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LoginResponse that = (LoginResponse)LoginResponse.class.cast(obj);
        return Objects.equal(this.username, that.username) && Objects.equal(this.userId, that.userId) && Objects.equal(this.password, that.password) && Objects.equal(this.domainId, that.domainId) && Objects.equal(this.timeout, that.timeout) && Objects.equal(this.registered, that.registered) && Objects.equal(this.accountName, that.accountName) && Objects.equal(this.firstName, that.firstName) && Objects.equal(this.lastName, that.lastName) && Objects.equal((Object)this.accountType, (Object)that.accountType) && Objects.equal(this.timezone, that.timezone) && Objects.equal(this.timezoneOffset, that.timezoneOffset) && Objects.equal(this.sessionKey, that.sessionKey) && Objects.equal(this.jSessionId, that.jSessionId);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).add("username", this.username).add("userId", this.userId).add("password", this.password).add("domainId", this.domainId).add("timeout", this.timeout).add("registered", this.registered).add("accountName", this.accountName).add("firstName", this.firstName).add("lastName", this.lastName).add("accountType", (Object)this.accountType).add("timezone", this.timezone).add("timezoneOffset", this.timezoneOffset).add("sessionKey", this.sessionKey).add("jSessionId", this.jSessionId);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String username;
        protected String userId;
        protected String password;
        protected String domainId;
        protected long timeout;
        protected boolean registered;
        protected String accountName;
        protected String firstName;
        protected String lastName;
        protected Account.Type accountType;
        protected String timezone;
        protected String timezoneOffset;
        protected String sessionKey;
        protected String jSessionId;

        protected abstract T self();

        public T username(String username) {
            this.username = username;
            return this.self();
        }

        public T userId(String userId) {
            this.userId = userId;
            return this.self();
        }

        public T password(String password) {
            this.password = password;
            return this.self();
        }

        public T domainId(String domainId) {
            this.domainId = domainId;
            return this.self();
        }

        public T timeout(long timeout) {
            this.timeout = timeout;
            return this.self();
        }

        public T registered(boolean registered) {
            this.registered = registered;
            return this.self();
        }

        public T accountName(String accountName) {
            this.accountName = accountName;
            return this.self();
        }

        public T firstName(String firstName) {
            this.firstName = firstName;
            return this.self();
        }

        public T lastName(String lastName) {
            this.lastName = lastName;
            return this.self();
        }

        public T accountType(Account.Type accountType) {
            this.accountType = accountType;
            return this.self();
        }

        public T timezone(String timezone) {
            this.timezone = timezone;
            return this.self();
        }

        public T timezoneOffset(String timezoneOffset) {
            this.timezoneOffset = timezoneOffset;
            return this.self();
        }

        public T sessionKey(String sessionKey) {
            this.sessionKey = sessionKey;
            return this.self();
        }

        public T jSessionId(String jSessionId) {
            this.jSessionId = jSessionId;
            return this.self();
        }

        public LoginResponse build() {
            return new LoginResponse(this.username, this.userId, this.password, this.domainId, this.timeout, this.registered, this.accountName, this.firstName, this.lastName, this.accountType, this.timezone, this.timezoneOffset, this.sessionKey, this.jSessionId);
        }

        public T fromLoginResponse(LoginResponse in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.username(in.getUsername())).userId(in.getUserId())).password(in.getPassword())).domainId(in.getDomainId())).timeout(in.getTimeout())).registered(in.isRegistered())).accountName(in.getAccountName())).firstName(in.getFirstName())).lastName(in.getLastName())).accountType(in.getAccountType())).timezone(in.getTimezone())).timezoneOffset(in.getTimezoneOffset())).sessionKey(in.getSessionKey())).jSessionId(in.getJSessionId());
        }
    }
}

