/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;

public class DiskOffering
implements Comparable<DiskOffering> {
    private final String id;
    private final String name;
    private final String displayText;
    private final Date created;
    private final String domain;
    private final String domainId;
    private final int diskSize;
    private final boolean customized;
    private final Set<String> tags;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromDiskOffering(this);
    }

    @ConstructorProperties(value={"id", "name", "displaytext", "created", "domain", "domainid", "disksize", "iscustomized", "tags"})
    protected DiskOffering(String id, @Nullable String name, @Nullable String displayText, @Nullable Date created, @Nullable String domain, @Nullable String domainId, int diskSize, boolean customized, @Nullable Iterable<String> tags) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.name = name;
        this.displayText = displayText;
        this.created = created;
        this.domain = domain;
        this.domainId = domainId;
        this.diskSize = diskSize;
        this.customized = customized;
        this.tags = tags != null ? ImmutableSet.copyOf(tags) : ImmutableSet.of();
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDisplayText() {
        return this.displayText;
    }

    @Nullable
    public Date getCreated() {
        return this.created;
    }

    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @Nullable
    public String getDomainId() {
        return this.domainId;
    }

    public int getDiskSize() {
        return this.diskSize;
    }

    public boolean isCustomized() {
        return this.customized;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.name, this.displayText, this.created, this.domain, this.domainId, this.diskSize, this.customized, this.tags);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DiskOffering that = (DiskOffering)DiskOffering.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.name, that.name) && Objects.equal(this.displayText, that.displayText) && Objects.equal(this.created, that.created) && Objects.equal(this.domain, that.domain) && Objects.equal(this.domainId, that.domainId) && Objects.equal(this.diskSize, that.diskSize) && Objects.equal(this.customized, that.customized) && Objects.equal(this.tags, that.tags);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("name", this.name).add("displayText", this.displayText).add("created", this.created).add("domain", this.domain).add("domainId", this.domainId).add("diskSize", this.diskSize).add("customized", this.customized).add("tags", this.tags);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(DiskOffering other) {
        return this.id.compareTo(other.getId());
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String name;
        protected String displayText;
        protected Date created;
        protected String domain;
        protected String domainId;
        protected int diskSize;
        protected boolean customized;
        protected ImmutableSet.Builder<String> tags = ImmutableSet.builder();

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T displayText(String displayText) {
            this.displayText = displayText;
            return this.self();
        }

        public T created(Date created) {
            this.created = created;
            return this.self();
        }

        public T domain(String domain) {
            this.domain = domain;
            return this.self();
        }

        public T domainId(String domainId) {
            this.domainId = domainId;
            return this.self();
        }

        public T diskSize(int diskSize) {
            this.diskSize = diskSize;
            return this.self();
        }

        public T customized(boolean customized) {
            this.customized = customized;
            return this.self();
        }

        public T tags(Iterable<String> tags) {
            this.tags = ImmutableSet.builder().addAll(tags);
            return this.self();
        }

        public T tag(String tag) {
            this.tags.add((Object)tag);
            return this.self();
        }

        public DiskOffering build() {
            return new DiskOffering(this.id, this.name, this.displayText, this.created, this.domain, this.domainId, this.diskSize, this.customized, this.tags.build());
        }

        public T fromDiskOffering(DiskOffering in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).name(in.getName())).displayText(in.getDisplayText())).created(in.getCreated())).domain(in.getDomain())).domainId(in.getDomainId())).diskSize(in.getDiskSize())).customized(in.isCustomized())).tags(in.getTags());
        }
    }
}

