/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.strategy.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.domain.Node;
import org.jclouds.chef.strategy.UpdateAutomaticAttributesOnNode;
import org.jclouds.domain.JsonBall;
import org.jclouds.logging.Logger;
import org.jclouds.ohai.Automatic;

@Singleton
public class UpdateAutomaticAttributesOnNodeImpl
implements UpdateAutomaticAttributesOnNode {
    @Resource
    @Named(value="jclouds.chef")
    protected Logger logger = Logger.NULL;
    private final ChefApi chef;
    private final Supplier<Map<String, JsonBall>> automaticSupplier;

    @Inject
    public UpdateAutomaticAttributesOnNodeImpl(ChefApi chef, @Automatic Supplier<Map<String, JsonBall>> automaticSupplier) {
        this.chef = Preconditions.checkNotNull(chef, "chef");
        this.automaticSupplier = Preconditions.checkNotNull(automaticSupplier, "automaticSupplier");
    }

    @Override
    public void execute(String nodeName) {
        this.logger.trace("updating node %s", nodeName);
        Node node = this.chef.getNode(nodeName);
        Node updated = Node.builder().name(node.getName()).normalAttributes(node.getNormalAttributes()).overrideAttributes(node.getOverrideAttributes()).defaultAttributes(node.getDefaultAttributes()).automaticAttributes(this.automaticSupplier.get()).runList(node.getRunList()).environment(node.getEnvironment()).build();
        this.chef.updateNode(updated);
        this.logger.debug("updated node %s", nodeName);
    }
}

