/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.strategy.internal;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.List;
import java.util.concurrent.Callable;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.domain.Node;
import org.jclouds.logging.Logger;

public abstract class BaseListNodesImpl {
    protected final ChefApi api;
    protected Logger logger = Logger.NULL;

    BaseListNodesImpl(ChefApi api) {
        this.api = Preconditions.checkNotNull(api, "api");
    }

    protected Iterable<? extends Node> execute(Iterable<String> toGet) {
        Iterable<Node> nodes = Iterables.transform(toGet, new Function<String, Node>(){

            @Override
            public Node apply(String input) {
                return BaseListNodesImpl.this.api.getNode(input);
            }
        });
        this.logger.trace(String.format("getting nodes: %s", Joiner.on(',').join(toGet)), new Object[0]);
        return nodes;
    }

    protected Iterable<? extends Node> executeConcurrently(final ListeningExecutorService executor, Iterable<String> toGet) {
        ListenableFuture<List<Node>> futures = Futures.allAsList(Iterables.transform(toGet, new Function<String, ListenableFuture<Node>>(){

            @Override
            public ListenableFuture<Node> apply(final String input) {
                return executor.submit(new Callable<Node>(){

                    @Override
                    public Node call() throws Exception {
                        return BaseListNodesImpl.this.api.getNode(input);
                    }
                });
            }
        }));
        this.logger.trace(String.format("getting nodes: %s", Joiner.on(',').join(toGet)), new Object[0]);
        return Futures.getUnchecked(futures);
    }
}

