/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.binders;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.chef.options.CreateClientOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.Json;
import org.jclouds.rest.binders.BindToJsonPayload;
import org.jclouds.rest.internal.GeneratedHttpRequest;

public class BindCreateClientOptionsToJsonPayload
extends BindToJsonPayload {
    @Inject
    public BindCreateClientOptionsToJsonPayload(Json jsonBinder) {
        super(jsonBinder);
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        Preconditions.checkArgument(Preconditions.checkNotNull(request, "request") instanceof GeneratedHttpRequest, "this binder is only valid for GeneratedHttpRequests");
        GeneratedHttpRequest gRequest = (GeneratedHttpRequest)request;
        Preconditions.checkState(gRequest.getInvocation().getArgs() != null, "args should be initialized at this point");
        String name = Preconditions.checkNotNull(postParams.remove("name"), "name").toString();
        CreateClientOptions options = (CreateClientOptions)Iterables.find(gRequest.getInvocation().getArgs(), Predicates.instanceOf(CreateClientOptions.class));
        return this.bindToRequest(request, new CreateClientParams(name, options));
    }

    private static class CreateClientParams {
        private String name;
        private boolean admin;

        public CreateClientParams(String name, CreateClientOptions options) {
            this.name = name;
            this.admin = options.isAdmin();
        }
    }
}

