/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.binders;

import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Bytes;
import java.util.List;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.binders.BindToStringPayload;

@Singleton
public class BindChecksumsToJsonPayload
extends BindToStringPayload {
    public HttpRequest bindToRequest(HttpRequest request, Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof Set, "this binder is only valid for Set!");
        Set md5s = (Set)input;
        StringBuilder builder = new StringBuilder();
        builder.append("{\"checksums\":{");
        for (List md5 : md5s) {
            builder.append(String.format("\"%s\":null,", BaseEncoding.base16().lowerCase().encode(Bytes.toArray(md5))));
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append("}}");
        super.bindToRequest(request, builder.toString());
        request.getPayload().getContentMetadata().setContentType("application/json");
        return request;
    }
}

