/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.strategy.internal;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.internal.BlobRuntimeException;
import org.jclouds.blobstore.reference.BlobStoreConstants;
import org.jclouds.blobstore.strategy.DeleteDirectoryStrategy;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;

@Singleton
public class MarkersDeleteDirectoryStrategy
implements DeleteDirectoryStrategy {
    private final BlobStore blobstore;
    private final ListeningExecutorService userExecutor;
    @Resource
    @Named(value="jclouds.blobstore")
    protected Logger logger = Logger.NULL;
    @Inject(optional=true)
    @Named(value="jclouds.request-timeout")
    protected Long maxTime;

    @Inject
    MarkersDeleteDirectoryStrategy(@Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, BlobStore blobstore) {
        this.userExecutor = userExecutor;
        this.blobstore = blobstore;
    }

    @Override
    public void execute(final String containerName, String directory) {
        Map exceptions;
        HashSet<String> names = Sets.newHashSet();
        names.add(directory);
        for (String string : BlobStoreConstants.DIRECTORY_SUFFIXES) {
            names.add(directory + string);
        }
        HashMap<String, Future> responses = Maps.newHashMap();
        for (final String name : names) {
            responses.put(name, this.userExecutor.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    MarkersDeleteDirectoryStrategy.this.blobstore.removeBlob(containerName, name);
                    return null;
                }
            }));
        }
        String string = String.format("deleting directory %s in containerName: %s", directory, containerName);
        try {
            exceptions = FutureIterables.awaitCompletion(responses, this.userExecutor, this.maxTime, this.logger, string);
        }
        catch (TimeoutException te) {
            throw Throwables.propagate(te);
        }
        if (!exceptions.isEmpty()) {
            throw new BlobRuntimeException(String.format("error %s: %s", string, exceptions));
        }
        assert (!this.blobstore.directoryExists(containerName, directory)) : String.format("still exists %s: %s", string, exceptions);
    }
}

