/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.options;

import com.google.common.base.Preconditions;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class AlertRequestOptions
extends BaseHttpRequestOptions {
    public static final AlertRequestOptions NONE = new AlertRequestOptions();

    public AlertRequestOptions withTargetResource(String targetResource) {
        Preconditions.checkState(!this.queryParameters.containsKey("targetResource"), "Can't have duplicate parameter of targetResource");
        this.queryParameters.put("targetResource", targetResource);
        return this;
    }

    public AlertRequestOptions withTargetResourceGroup(String targetResourceGroup) {
        Preconditions.checkState(!this.queryParameters.containsKey("targetResourceGroup"), "Can't have duplicate parameter of targetResourceGroup");
        this.queryParameters.put("targetResourceGroup", targetResourceGroup);
        return this;
    }

    public AlertRequestOptions withTargetResourceType(String targetResourceType) {
        Preconditions.checkState(!this.queryParameters.containsKey("targetResourceGroupType"), "Can't have duplicate parameter of targetResourceType");
        this.queryParameters.put("targetResourceGroupType", targetResourceType);
        return this;
    }

    public AlertRequestOptions withMonitorService(String monitorService) {
        Preconditions.checkState(!this.queryParameters.containsKey("monitorService"), "Can't have duplicate parameter of monitorService");
        this.queryParameters.put("monitorService", monitorService);
        return this;
    }

    public AlertRequestOptions withMonitorCondition(String monitorCondition) {
        Preconditions.checkState(!this.queryParameters.containsKey("monitorCondition"), "Can't have duplicate parameter of monitorCondition");
        this.queryParameters.put("monitorCondition", monitorCondition);
        return this;
    }

    public AlertRequestOptions withSeverity(String severity) {
        Preconditions.checkState(!this.queryParameters.containsKey("severity"), "Can't have duplicate parameter of severity");
        this.queryParameters.put("severity", severity);
        return this;
    }

    public AlertRequestOptions withAlertState(String alertState) {
        Preconditions.checkState(!this.queryParameters.containsKey("alertState"), "Can't have duplicate parameter of alertState");
        this.queryParameters.put("alertState", alertState);
        return this;
    }

    public AlertRequestOptions withAlertRule(String alertRule) {
        Preconditions.checkState(!this.queryParameters.containsKey("alertRule"), "Can't have duplicate parameter of alertRule");
        this.queryParameters.put("alertRule", alertRule);
        return this;
    }

    public AlertRequestOptions withSmartGroupId(String smartGroupId) {
        Preconditions.checkState(!this.queryParameters.containsKey("smartGroupId"), "Can't have duplicate parameter of smartGroupId");
        this.queryParameters.put("smartGroupId", smartGroupId);
        return this;
    }

    public AlertRequestOptions withIncludeContext(boolean includeContext) {
        Preconditions.checkState(!this.queryParameters.containsKey("includeContext"), "Can't have duplicate parameter of includeContext");
        this.queryParameters.put("includeContext", String.valueOf(includeContext));
        return this;
    }

    public AlertRequestOptions withIncludeEgressConfig(boolean includeEgressConfig) {
        Preconditions.checkState(!this.queryParameters.containsKey("includeEgressConfig"), "Can't have duplicate parameter of includeEgressConfig");
        this.queryParameters.put("includeEgressConfig", String.valueOf(includeEgressConfig));
        return this;
    }

    public AlertRequestOptions withPageCount(int pageCount) {
        Preconditions.checkState(!this.queryParameters.containsKey("pageCount"), "Can't have duplicate parameter of pageCount");
        this.queryParameters.put("pageCount", String.valueOf(pageCount));
        return this;
    }

    public AlertRequestOptions withSortBy(String sortBy) {
        Preconditions.checkState(!this.queryParameters.containsKey("sortBy"), "Can't have duplicate parameter of sortBy");
        this.queryParameters.put("sortBy", sortBy);
        return this;
    }

    public AlertRequestOptions withSortOrder(String sortOrder) {
        Preconditions.checkState(!this.queryParameters.containsKey("sortOrder"), "Can't have duplicate parameter of sortOrder");
        this.queryParameters.put("sortOrder", sortOrder);
        return this;
    }

    public AlertRequestOptions withSelect(String select) {
        Preconditions.checkState(!this.queryParameters.containsKey("select"), "Can't have duplicate parameter of select");
        this.queryParameters.put("select", select);
        return this;
    }

    public AlertRequestOptions withTimeRange(String timeRange) {
        Preconditions.checkState(!this.queryParameters.containsKey("timeRange"), "Can't have duplicate parameter of timeRange");
        this.queryParameters.put("timeRange", timeRange);
        return this;
    }

    public AlertRequestOptions withCustomTimeRange(String customTimeRange) {
        Preconditions.checkState(!this.queryParameters.containsKey("customTimeRange"), "Can't have duplicate parameter of customTimeRange");
        this.queryParameters.put("customTimeRange", customTimeRange);
        return this;
    }

    public AlertRequestOptions withGroupBy(String groupby) {
        Preconditions.checkState(!this.queryParameters.containsKey("groupby"), "Can't have duplicate parameter of groupby");
        this.queryParameters.put("groupby", groupby);
        return this;
    }

    public AlertRequestOptions withIncludeSmartGroupsCount(boolean includeSmartGroupsCount) {
        Preconditions.checkState(!this.queryParameters.containsKey("includeSmartGroupsCount"), "Can't have duplicate parameter of includeSmartGroupsCount");
        this.queryParameters.put("includeSmartGroupsCount", String.valueOf(includeSmartGroupsCount));
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlertRequestOptions options = (AlertRequestOptions)o;
        return this.buildQueryParameters().equals(options.buildQueryParameters());
    }

    @Override
    public int hashCode() {
        return this.buildQueryParameters().hashCode();
    }

    public static class Builder {
        public static AlertRequestOptions targetResource(String targetResource) {
            return new AlertRequestOptions().withTargetResource(targetResource);
        }

        public static AlertRequestOptions targetResourceGroup(String targetResourceGroup) {
            return new AlertRequestOptions().withTargetResourceGroup(targetResourceGroup);
        }

        public static AlertRequestOptions targetResourceGroupType(String targetResourceGroupType) {
            return new AlertRequestOptions().withTargetResourceType(targetResourceGroupType);
        }

        public static AlertRequestOptions monitorService(String monitorService) {
            return new AlertRequestOptions().withMonitorService(monitorService);
        }

        public static AlertRequestOptions monitorCondition(String monitorCondition) {
            return new AlertRequestOptions().withMonitorCondition(monitorCondition);
        }

        public static AlertRequestOptions severity(String severity) {
            return new AlertRequestOptions().withSeverity(severity);
        }

        public static AlertRequestOptions alertState(String alertState) {
            return new AlertRequestOptions().withAlertState(alertState);
        }

        public static AlertRequestOptions alertRule(String alertRule) {
            return new AlertRequestOptions().withAlertRule(alertRule);
        }

        public static AlertRequestOptions smartGroupId(String smartGroupId) {
            return new AlertRequestOptions().withSmartGroupId(smartGroupId);
        }

        public static AlertRequestOptions includeContext(boolean includeContext) {
            return new AlertRequestOptions().withIncludeContext(includeContext);
        }

        public static AlertRequestOptions includeEgressConfig(boolean includeEgressConfig) {
            return new AlertRequestOptions().withIncludeEgressConfig(includeEgressConfig);
        }

        public static AlertRequestOptions pageCount(int pageCount) {
            return new AlertRequestOptions().withPageCount(pageCount);
        }

        public static AlertRequestOptions sortBy(String sortBy) {
            return new AlertRequestOptions().withSortBy(sortBy);
        }

        public static AlertRequestOptions sortOrder(String sortOrder) {
            return new AlertRequestOptions().withSortOrder(sortOrder);
        }

        public static AlertRequestOptions select(String select) {
            return new AlertRequestOptions().withSelect(select);
        }

        public static AlertRequestOptions timeRange(String timeRange) {
            return new AlertRequestOptions().withTimeRange(timeRange);
        }

        public static AlertRequestOptions customTimeRange(String customTimeRange) {
            return new AlertRequestOptions().withCustomTimeRange(customTimeRange);
        }

        public static AlertRequestOptions groupBy(String groupBy) {
            return new AlertRequestOptions().withGroupBy(groupBy);
        }

        public static AlertRequestOptions includeSmartGroupsCount(boolean includeSmartGroupsCount) {
            return new AlertRequestOptions().withIncludeSmartGroupsCount(includeSmartGroupsCount);
        }
    }
}

