/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.features;

import java.util.List;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.azurecompute.arm.domain.Alert;
import org.jclouds.azurecompute.arm.domain.AlertModification;
import org.jclouds.azurecompute.arm.domain.AlertSummary;
import org.jclouds.azurecompute.arm.filters.ApiVersionFilter;
import org.jclouds.azurecompute.arm.options.AlertRequestOptions;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;

@Path(value="/{resourceid}")
@RequestFilters(value={OAuthFilter.class, ApiVersionFilter.class})
@Consumes(value={"application/json"})
public interface AlertApi {
    @Named(value="alerts:getAll")
    @Path(value="/providers/Microsoft.AlertsManagement/alerts")
    @GET
    @SelectJson(value={"value"})
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<Alert> list(AlertRequestOptions ... var1);

    @Named(value="alerts:getbyid")
    @Path(value="/providers/Microsoft.AlertsManagement/alerts/{alertId}")
    @GET
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Alert get(@PathParam(value="alertId") String var1);

    @Named(value="alerts:changestate")
    @Path(value="/providers/Microsoft.AlertsManagement/alerts/{alertId}/changestate")
    @POST
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Alert changeState(@PathParam(value="alertId") String var1, @QueryParam(value="newState") String var2);

    @Named(value="alerts:history")
    @Path(value="/providers/Microsoft.AlertsManagement/alerts/{alertId}/history")
    @GET
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public AlertModification getHistory(@PathParam(value="alertId") String var1);

    @Named(value="alerts:summary")
    @Path(value="providers/Microsoft.AlertsManagement/alertsSummary")
    @GET
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public AlertSummary getSummary(AlertRequestOptions ... var1);
}

