/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain.vpn;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.azurecompute.arm.domain.AddressSpace;
import org.jclouds.azurecompute.arm.domain.vpn.AutoValue_VPNClientConfiguration;
import org.jclouds.azurecompute.arm.domain.vpn.IPSecPolicy;
import org.jclouds.azurecompute.arm.domain.vpn.VPNClientRevokedCertificate;
import org.jclouds.azurecompute.arm.domain.vpn.VPNClientRootCertificate;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class VPNClientConfiguration {
    @Nullable
    public abstract String radiusServerAddress();

    @Nullable
    public abstract String radiusServerSecret();

    @Nullable
    public abstract AddressSpace vpnClientAddressPool();

    public abstract List<IPSecPolicy> vpnClientIpsecPolicies();

    public abstract List<String> vpnClientProtocols();

    public abstract List<VPNClientRevokedCertificate> vpnClientRevokedCertificates();

    public abstract List<VPNClientRootCertificate> vpnClientRootCertificates();

    VPNClientConfiguration() {
    }

    @SerializedNames(value={"radiusServerAddress", "radiusServerSecret", "vpnClientAddressPool", "vpnClientIpsecPolicies", "vpnClientProtocols", "vpnClientRevokedCertificates", "vpnClientRootCertificates"})
    public static VPNClientConfiguration create(String radiusServerAddress, String radiusServerSecret, AddressSpace vpnClientAddressPool, List<IPSecPolicy> vpnClientIpsecPolicies, List<String> vpnClientProtocols, List<VPNClientRevokedCertificate> vpnClientRevokedCertificates, List<VPNClientRootCertificate> vpnClientRootCertificates) {
        return VPNClientConfiguration.builder().radiusServerAddress(radiusServerAddress).radiusServerSecret(radiusServerSecret).vpnClientAddressPool(vpnClientAddressPool).vpnClientIpsecPolicies(vpnClientIpsecPolicies).vpnClientProtocols(vpnClientProtocols).vpnClientRevokedCertificates(vpnClientRevokedCertificates).vpnClientRootCertificates(vpnClientRootCertificates).build();
    }

    public static Builder builder() {
        return new AutoValue_VPNClientConfiguration.Builder();
    }

    public abstract Builder toBuilder();

    public static abstract class Builder {
        public abstract Builder radiusServerAddress(String var1);

        public abstract Builder radiusServerSecret(String var1);

        public abstract Builder vpnClientAddressPool(AddressSpace var1);

        public abstract Builder vpnClientIpsecPolicies(List<IPSecPolicy> var1);

        public abstract Builder vpnClientProtocols(List<String> var1);

        public abstract Builder vpnClientRevokedCertificates(List<VPNClientRevokedCertificate> var1);

        public abstract Builder vpnClientRootCertificates(List<VPNClientRootCertificate> var1);

        abstract List<IPSecPolicy> vpnClientIpsecPolicies();

        abstract List<String> vpnClientProtocols();

        abstract List<VPNClientRevokedCertificate> vpnClientRevokedCertificates();

        abstract List<VPNClientRootCertificate> vpnClientRootCertificates();

        abstract VPNClientConfiguration autoBuild();

        public VPNClientConfiguration build() {
            this.vpnClientIpsecPolicies(this.vpnClientIpsecPolicies() == null ? ImmutableList.of() : ImmutableList.copyOf(this.vpnClientIpsecPolicies()));
            this.vpnClientProtocols(this.vpnClientProtocols() == null ? ImmutableList.of() : ImmutableList.copyOf(this.vpnClientProtocols()));
            this.vpnClientRevokedCertificates(this.vpnClientRevokedCertificates() == null ? ImmutableList.of() : ImmutableList.copyOf(this.vpnClientRevokedCertificates()));
            this.vpnClientRootCertificates(this.vpnClientRootCertificates() == null ? ImmutableList.of() : ImmutableList.copyOf(this.vpnClientRootCertificates()));
            return this.autoBuild();
        }
    }
}

