/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.azurecompute.arm.domain.AutoValue_VirtualMachineScaleSetIpConfigurationProperties;
import org.jclouds.azurecompute.arm.domain.IdReference;
import org.jclouds.azurecompute.arm.domain.Subnet;
import org.jclouds.azurecompute.arm.domain.VirtualMachineScaleSetPublicIPAddressConfiguration;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class VirtualMachineScaleSetIpConfigurationProperties {
    @Nullable
    public abstract VirtualMachineScaleSetPublicIPAddressConfiguration publicIPAddressConfiguration();

    public abstract Subnet subnet();

    @Nullable
    public abstract String privateIPAddressVersion();

    public abstract List<IdReference> loadBalancerBackendAddressPools();

    public abstract List<IdReference> loadBalancerInboundNatPools();

    @Nullable
    public abstract String applicationGatewayBackendAddressPools();

    @SerializedNames(value={"publicIPAddressConfiguration", "subnet", "privateIPAddressVersion", "loadBalancerBackendAddressPools", "loadBalancerInboundNatPools", "applicationGatewayBackendAddressPools"})
    public static VirtualMachineScaleSetIpConfigurationProperties create(VirtualMachineScaleSetPublicIPAddressConfiguration publicIPAddressConfiguration, Subnet subnet, String privateIPAddressVersion, List<IdReference> loadBalancerBackendAddressPools, List<IdReference> loadBalancerInboundNatPools, String applicationGatewayBackendAddressPools) {
        return VirtualMachineScaleSetIpConfigurationProperties.builder().publicIPAddressConfiguration(publicIPAddressConfiguration).subnet(subnet).privateIPAddressVersion(privateIPAddressVersion).loadBalancerBackendAddressPools(loadBalancerBackendAddressPools != null ? ImmutableList.copyOf(loadBalancerBackendAddressPools) : ImmutableList.of()).loadBalancerInboundNatPools(loadBalancerInboundNatPools != null ? ImmutableList.copyOf(loadBalancerInboundNatPools) : ImmutableList.of()).applicationGatewayBackendAddressPools(applicationGatewayBackendAddressPools).build();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_VirtualMachineScaleSetIpConfigurationProperties.Builder();
    }

    public static abstract class Builder {
        public abstract Builder publicIPAddressConfiguration(VirtualMachineScaleSetPublicIPAddressConfiguration var1);

        public abstract Builder subnet(Subnet var1);

        public abstract Builder loadBalancerBackendAddressPools(List<IdReference> var1);

        public abstract Builder loadBalancerInboundNatPools(List<IdReference> var1);

        public abstract Builder privateIPAddressVersion(String var1);

        public abstract Builder applicationGatewayBackendAddressPools(String var1);

        public abstract VirtualMachineScaleSetIpConfigurationProperties build();
    }
}

