/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jclouds.azurecompute.arm.domain.AutoValue_Subnet;
import org.jclouds.azurecompute.arm.domain.AutoValue_Subnet_IpConfiguration;
import org.jclouds.azurecompute.arm.domain.AutoValue_Subnet_SubnetProperties;
import org.jclouds.azurecompute.arm.domain.Provisionable;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class Subnet {
    public static final String GATEWAY_SUBNET_NAME = "GatewaySubnet";
    private static final Pattern NETWORK_PATTERN = Pattern.compile("^.*/virtualNetworks/([^/]+)(/.*)?$");

    @Nullable
    public abstract String name();

    @Nullable
    public abstract String id();

    @Nullable
    public abstract String etag();

    @Nullable
    public abstract SubnetProperties properties();

    @Nullable
    public String virtualNetwork() {
        return Subnet.extractVirtualNetwork(this.id());
    }

    public static String extractVirtualNetwork(String id) {
        if (id == null) {
            return null;
        }
        Matcher m3 = NETWORK_PATTERN.matcher(id);
        m3.matches();
        return m3.group(1);
    }

    @SerializedNames(value={"name", "id", "etag", "properties"})
    public static Subnet create(String name, String id, String etag, SubnetProperties properties) {
        return Subnet.builder().name(name).id(id).etag(etag).properties(properties).build();
    }

    Subnet() {
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_Subnet.Builder();
    }

    public static abstract class Builder {
        public abstract Builder name(String var1);

        public abstract Builder id(String var1);

        public abstract Builder etag(String var1);

        public abstract Builder properties(SubnetProperties var1);

        public Builder setGatewaySubnet() {
            return this.name(Subnet.GATEWAY_SUBNET_NAME);
        }

        public abstract Subnet build();
    }

    public static abstract class SubnetProperties
    implements Provisionable {
        @Override
        @Nullable
        public abstract String provisioningState();

        @Nullable
        public abstract String addressPrefix();

        @Nullable
        public abstract List<IpConfiguration> ipConfigurations();

        @SerializedNames(value={"provisioningState", "addressPrefix", "ipConfigurations"})
        public static SubnetProperties create(String provisioningState, String addressPrefix, List<IpConfiguration> ipConfigurations) {
            return SubnetProperties.builder().provisioningState(provisioningState).addressPrefix(addressPrefix).ipConfigurations(ipConfigurations != null ? ImmutableList.copyOf(ipConfigurations) : null).build();
        }

        SubnetProperties() {
        }

        public abstract Builder toBuilder();

        public static Builder builder() {
            return new AutoValue_Subnet_SubnetProperties.Builder();
        }

        public static abstract class Builder {
            public abstract Builder provisioningState(String var1);

            public abstract Builder addressPrefix(String var1);

            public abstract Builder ipConfigurations(List<IpConfiguration> var1);

            abstract List<IpConfiguration> ipConfigurations();

            abstract SubnetProperties autoBuild();

            public SubnetProperties build() {
                this.ipConfigurations(this.ipConfigurations() != null ? ImmutableList.copyOf(this.ipConfigurations()) : null);
                return this.autoBuild();
            }
        }
    }

    public static abstract class IpConfiguration {
        public abstract String id();

        @SerializedNames(value={"id"})
        public static IpConfiguration create(String id) {
            return new AutoValue_Subnet_IpConfiguration(id);
        }

        IpConfiguration() {
        }
    }
}

