/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jclouds.azurecompute.arm.domain.AutoValue_MetricAlert;
import org.jclouds.azurecompute.arm.domain.MetricAlertProperties;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class MetricAlert {
    public abstract String id();

    public abstract String name();

    public abstract String location();

    public abstract String type();

    @Nullable
    public abstract Map<String, String> tags();

    @Nullable
    public abstract MetricAlertProperties properties();

    @SerializedNames(value={"id", "name", "location", "type", "tags", "properties"})
    public static MetricAlert create(String id, String name, String location, String type, Map<String, String> tags, MetricAlertProperties properties) {
        return MetricAlert.builder().id(id).name(name).location(location).type(type).tags(tags).properties(properties).build();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_MetricAlert.Builder();
    }

    public static abstract class Builder {
        public abstract Builder id(String var1);

        public abstract Builder name(String var1);

        public abstract Builder location(String var1);

        public abstract Builder type(String var1);

        public abstract Builder tags(Map<String, String> var1);

        public abstract Builder properties(MetricAlertProperties var1);

        abstract Map<String, String> tags();

        abstract MetricAlert autoBuild();

        public MetricAlert build() {
            this.tags(this.tags() != null ? ImmutableMap.copyOf(this.tags()) : null);
            return this.autoBuild();
        }
    }
}

