/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.compute.loaders;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheLoader;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.azurecompute.arm.AzureComputeApi;
import org.jclouds.azurecompute.arm.compute.config.AzurePredicatesModule;
import org.jclouds.azurecompute.arm.compute.domain.ResourceGroupAndNameAndIngressRules;
import org.jclouds.azurecompute.arm.domain.NetworkSecurityGroup;
import org.jclouds.azurecompute.arm.domain.NetworkSecurityGroupProperties;
import org.jclouds.azurecompute.arm.domain.NetworkSecurityRule;
import org.jclouds.azurecompute.arm.domain.NetworkSecurityRuleProperties;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.logging.Logger;

@Singleton
public class CreateSecurityGroupIfNeeded
extends CacheLoader<ResourceGroupAndNameAndIngressRules, String> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final AzureComputeApi api;
    private final AzurePredicatesModule.SecurityGroupAvailablePredicateFactory securityGroupAvailable;

    @Inject
    CreateSecurityGroupIfNeeded(AzureComputeApi api, AzurePredicatesModule.SecurityGroupAvailablePredicateFactory securityRuleAvailable) {
        this.api = api;
        this.securityGroupAvailable = securityRuleAvailable;
    }

    @Override
    public String load(ResourceGroupAndNameAndIngressRules key) throws Exception {
        return this.createSecurityGroup(key.location(), key.resourceGroup(), key.name(), key.inboundPorts());
    }

    private String createSecurityGroup(String location, String resourceGroup, String name, int[] inboundPorts) {
        this.logger.debug(">> creating security group %s in %s...", name, location);
        Map<Integer, Integer> portRanges = ComputeServiceUtils.getPortRangesFromList(inboundPorts);
        ArrayList<NetworkSecurityRule> rules = new ArrayList<NetworkSecurityRule>();
        int startPriority = 100;
        for (Map.Entry<Integer, Integer> portRange : portRanges.entrySet()) {
            String range = portRange.getKey() + "-" + portRange.getValue();
            String ruleName = "tcp-" + range;
            NetworkSecurityRuleProperties properties = NetworkSecurityRuleProperties.builder().protocol(NetworkSecurityRuleProperties.Protocol.Tcp).sourceAddressPrefix("*").sourcePortRange("*").destinationAddressPrefix("*").destinationPortRange(range).direction(NetworkSecurityRuleProperties.Direction.Inbound).access(NetworkSecurityRuleProperties.Access.Allow).priority(startPriority++).build();
            rules.add(NetworkSecurityRule.create(ruleName, null, null, properties));
        }
        NetworkSecurityGroup securityGroup = this.api.getNetworkSecurityGroupApi(resourceGroup).createOrUpdate(name, location, null, NetworkSecurityGroupProperties.builder().securityRules(rules).build());
        Preconditions.checkState(this.securityGroupAvailable.create(resourceGroup).apply(name), "Security group was not created in the configured timeout");
        return securityGroup.id();
    }
}

