/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.compute.config;

import com.google.common.base.CharMatcher;
import com.google.inject.Singleton;
import org.jclouds.predicates.Validator;

@Singleton
public class AzureNameValidator
extends Validator<String> {
    private static final int minLength = 2;
    private static final int maxLength = 63;

    @Override
    public void validate(String name) {
        if (name == null || name.length() < 2 || name.length() > 63) {
            throw this.exception(name, "Can't be null or empty. Length must be 2 to 63 symbols");
        }
        if (!Character.isLetterOrDigit(name.charAt(0))) {
            throw this.exception(name, "Should start with letter/number");
        }
        CharMatcher range = this.getAcceptableRange();
        if (!range.matchesAllOf(name)) {
            throw this.exception(name, "Should have lowercase or uppercase ASCII letters, numbers, dashes, underscores and periods");
        }
    }

    private CharMatcher getAcceptableRange() {
        return CharMatcher.inRange('a', 'z').or(CharMatcher.inRange('A', 'Z')).or(CharMatcher.inRange('0', '9')).or(CharMatcher.anyOf("-_."));
    }

    protected IllegalArgumentException exception(String name, String reason) {
        return new IllegalArgumentException(String.format("Object '%s' doesn't match Azure naming constraints: %s", name, reason));
    }
}

