/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm;

import java.net.URI;
import java.util.Properties;
import org.jclouds.azurecompute.arm.AzureManagementApiMetadata;
import org.jclouds.azurecompute.arm.domain.Region;
import org.jclouds.azurecompute.arm.features.ActivityLogAlertApi;
import org.jclouds.azurecompute.arm.features.AlertApi;
import org.jclouds.azurecompute.arm.features.AvailabilitySetApi;
import org.jclouds.azurecompute.arm.features.DeploymentApi;
import org.jclouds.azurecompute.arm.features.DiskApi;
import org.jclouds.azurecompute.arm.features.GraphRBACApi;
import org.jclouds.azurecompute.arm.features.ImageApi;
import org.jclouds.azurecompute.arm.features.LoadBalancerApi;
import org.jclouds.azurecompute.arm.features.LocalNetworkGatewayApi;
import org.jclouds.azurecompute.arm.features.LocationApi;
import org.jclouds.azurecompute.arm.features.MetricAlertApi;
import org.jclouds.azurecompute.arm.features.MetricDefinitionsApi;
import org.jclouds.azurecompute.arm.features.MetricsApi;
import org.jclouds.azurecompute.arm.features.NetworkInterfaceCardApi;
import org.jclouds.azurecompute.arm.features.NetworkSecurityGroupApi;
import org.jclouds.azurecompute.arm.features.NetworkSecurityRuleApi;
import org.jclouds.azurecompute.arm.features.OSImageApi;
import org.jclouds.azurecompute.arm.features.PublicIPAddressApi;
import org.jclouds.azurecompute.arm.features.ResourceGroupApi;
import org.jclouds.azurecompute.arm.features.ResourceProviderApi;
import org.jclouds.azurecompute.arm.features.StorageAccountApi;
import org.jclouds.azurecompute.arm.features.SubnetApi;
import org.jclouds.azurecompute.arm.features.VMSizeApi;
import org.jclouds.azurecompute.arm.features.VaultApi;
import org.jclouds.azurecompute.arm.features.VirtualMachineApi;
import org.jclouds.azurecompute.arm.features.VirtualMachineScaleSetApi;
import org.jclouds.azurecompute.arm.features.VirtualNetworkApi;
import org.jclouds.azurecompute.arm.features.VirtualNetworkGatewayApi;
import org.jclouds.azurecompute.arm.features.VirtualNetworkGatewayConnectionApi;
import org.jclouds.oauth.v2.config.CredentialType;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.internal.BaseProviderMetadata;

public class AzureComputeProviderMetadata
extends BaseProviderMetadata {
    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return AzureComputeProviderMetadata.builder().fromProviderMetadata(this);
    }

    public AzureComputeProviderMetadata() {
        super(AzureComputeProviderMetadata.builder());
    }

    public static Properties defaultProperties() {
        Properties properties = AzureManagementApiMetadata.defaultProperties();
        properties.put("jclouds.compute.poll-status.initial-period", (Object)1000);
        properties.put("jclouds.compute.poll-status.max-period", (Object)15000);
        properties.put("jclouds.azurecompute.arm.operation.timeout", (Object)46000000);
        properties.put("jclouds.compute.timeout.node-terminated", (Object)600000);
        properties.put("jclouds.max-ratelimit-wait", (Object)330000);
        properties.put("jclouds.session-interval", (Object)300);
        properties.put("jclouds.oauth.resource", "https://management.azure.com/");
        properties.put("jclouds.oauth.credential-type", CredentialType.CLIENT_CREDENTIALS_SECRET.toString());
        properties.put("oauth.endpoint", "https://login.microsoft.com/${azurecompute-arm.tenantId}/oauth2/token");
        properties.put("jclouds.azurecompute.arm.vnet.addressprefix", "10.0.0.0/16");
        properties.put("jclouds.azurecompute.arm.subnet.addressprefix", "10.0.0.0/24");
        properties.put("jclouds.compute.resourcename-prefix", "jclouds");
        properties.put("jclouds.compute.resourcename-delimiter", "-");
        properties.put("jclouds.azurecompute.arm.publishers", "Canonical,RedHat");
        properties.put("jclouds.image.login-user", "jclouds");
        properties.put("jclouds.image.authenticate-sudo", "true");
        properties.put("jclouds.template", "imageNameMatches=UbuntuServer,osVersionMatches=1[456]\\.[01][04](\\.[0-9])?-LTS");
        properties.put("jclouds.azurecompute.arm.apiversion." + DeploymentApi.class.getSimpleName(), "2016-02-01");
        properties.put("jclouds.azurecompute.arm.apiversion." + LocationApi.class.getSimpleName(), "2015-11-01");
        properties.put("jclouds.azurecompute.arm.apiversion." + NetworkInterfaceCardApi.class.getSimpleName(), "2017-03-01");
        properties.put("jclouds.azurecompute.arm.apiversion." + NetworkSecurityGroupApi.class.getSimpleName(), "2016-03-30");
        properties.put("jclouds.azurecompute.arm.apiversion." + NetworkSecurityRuleApi.class.getSimpleName(), "2016-03-30");
        properties.put("jclouds.azurecompute.arm.apiversion." + OSImageApi.class.getSimpleName(), "2015-06-15");
        properties.put("jclouds.azurecompute.arm.apiversion." + PublicIPAddressApi.class.getSimpleName(), "2018-08-01");
        properties.put("jclouds.azurecompute.arm.apiversion." + ResourceGroupApi.class.getSimpleName(), "2015-01-01");
        properties.put("jclouds.azurecompute.arm.apiversion." + ResourceProviderApi.class.getSimpleName(), "2015-01-01");
        properties.put("jclouds.azurecompute.arm.apiversion." + StorageAccountApi.class.getSimpleName(), "2015-06-15");
        properties.put("jclouds.azurecompute.arm.apiversion." + SubnetApi.class.getSimpleName(), "2017-03-01");
        properties.put("jclouds.azurecompute.arm.apiversion." + VirtualNetworkApi.class.getSimpleName(), "2015-06-15");
        properties.put("jclouds.azurecompute.arm.apiversion." + VMSizeApi.class.getSimpleName(), "2015-06-15");
        properties.put("jclouds.azurecompute.arm.apiversion." + VirtualMachineApi.class.getSimpleName(), "2018-06-01");
        properties.put("jclouds.azurecompute.arm.apiversion." + LoadBalancerApi.class.getSimpleName(), "2018-08-01");
        properties.put("jclouds.azurecompute.arm.apiversion." + AvailabilitySetApi.class.getSimpleName(), "2016-04-30-preview");
        properties.put("jclouds.azurecompute.arm.apiversion." + DiskApi.class.getSimpleName(), "2017-03-30");
        properties.put("jclouds.azurecompute.arm.apiversion." + ImageApi.class.getSimpleName(), "2016-04-30-preview");
        properties.put("jclouds.azurecompute.arm.apiversion." + MetricDefinitionsApi.class.getSimpleName(), "2017-05-01-preview");
        properties.put("jclouds.azurecompute.arm.apiversion." + MetricsApi.class.getSimpleName(), "2016-09-01");
        properties.put("jclouds.azurecompute.arm.apiversion." + VirtualMachineScaleSetApi.class.getSimpleName(), "2017-03-30");
        properties.put("jclouds.azurecompute.arm.apiversion." + GraphRBACApi.class.getSimpleName(), "1.6");
        properties.put("jclouds.azurecompute.arm.apiversion." + VaultApi.class.getSimpleName(), "2016-10-01");
        properties.put("jclouds.azurecompute.arm.apiversion." + LocalNetworkGatewayApi.class.getSimpleName(), "2018-02-01");
        properties.put("jclouds.azurecompute.arm.apiversion." + VirtualNetworkGatewayApi.class.getSimpleName(), "2018-02-01");
        properties.put("jclouds.azurecompute.arm.apiversion." + VirtualNetworkGatewayConnectionApi.class.getSimpleName(), "2018-02-01");
        properties.put("jclouds.azurecompute.arm.apiversion." + ActivityLogAlertApi.class.getSimpleName(), "2020-10-01");
        properties.put("jclouds.azurecompute.arm.apiversion." + AlertApi.class.getSimpleName(), "2019-03-01");
        properties.put("jclouds.azurecompute.arm.apiversion." + MetricAlertApi.class.getSimpleName(), "2018-03-01");
        return properties;
    }

    public AzureComputeProviderMetadata(Builder builder) {
        super(builder);
    }

    public static class Builder
    extends BaseProviderMetadata.Builder {
        protected Builder() {
            ((BaseProviderMetadata.Builder)this.id("azurecompute-arm").name("Azure Resource Management").apiMetadata(new AzureManagementApiMetadata()).endpoint("https://management.azure.com/subscriptions/${azurecompute-arm.subscriptionId}").homepage(URI.create("https://www.windowsazure.com/")).console(URI.create("https://windows.azure.com/default.aspx")).linkedServices("azureblob").iso3166Codes(Region.iso3166Codes())).defaultProperties(AzureComputeProviderMetadata.defaultProperties());
        }

        @Override
        public AzureComputeProviderMetadata build() {
            return new AzureComputeProviderMetadata(this);
        }

        @Override
        public Builder fromProviderMetadata(ProviderMetadata providerMetadata) {
            super.fromProviderMetadata(providerMetadata);
            return this;
        }
    }
}

