/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore.config;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.azure.storage.config.AuthType;
import org.jclouds.azureblob.AzureBlobClient;
import org.jclouds.azureblob.blobstore.AzureBlobRequestSigner;
import org.jclouds.azureblob.blobstore.AzureBlobStore;
import org.jclouds.azureblob.config.InsufficientAccessRightsException;
import org.jclouds.azureblob.domain.PublicAccess;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.attr.ConsistencyModel;

public class AzureBlobStoreContextModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bind(ConsistencyModel.class).toInstance(ConsistencyModel.STRICT);
        this.bind(BlobStore.class).to(AzureBlobStore.class).in(Scopes.SINGLETON);
        this.bind(BlobRequestSigner.class).to(AzureBlobRequestSigner.class);
    }

    @Provides
    @Singleton
    protected final LoadingCache<String, PublicAccess> containerAcls(final AzureBlobClient client, final @Named(value="sasAuth") boolean sasAuthentication, final AuthType authType) {
        return CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build(new CacheLoader<String, PublicAccess>(){

            @Override
            public PublicAccess load(String container) throws CacheLoader.InvalidCacheLoadException {
                if (!sasAuthentication && authType == AuthType.AZURE_KEY) {
                    return client.getPublicAccessForContainer(container);
                }
                throw new InsufficientAccessRightsException("SAS Authentication does not support getAcl and setAcl calls.");
            }

            public String toString() {
                return "getPublicAccessForContainer()";
            }
        });
    }
}

