/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.config;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.inject.Injector;
import com.google.inject.Provides;
import javax.inject.Singleton;
import org.jclouds.aws.s3.AWSS3Client;
import org.jclouds.aws.s3.filters.AWSRequestAuthorizeSignatureV4;
import org.jclouds.aws.s3.predicates.validators.AWSS3BucketNameValidator;
import org.jclouds.location.Region;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.config.S3HttpApiModule;
import org.jclouds.s3.filters.RequestAuthorizeSignature;
import org.jclouds.s3.predicates.validators.BucketNameValidator;

@ConfiguresHttpApi
public class AWSS3HttpApiModule
extends S3HttpApiModule<AWSS3Client> {
    public AWSS3HttpApiModule() {
        super(AWSS3Client.class);
    }

    @Override
    protected Supplier<String> defaultRegionForBucket(@Region Supplier<String> defaultRegion) {
        return Suppliers.ofInstance("us-standard");
    }

    @Override
    protected void configure() {
        this.bind(BucketNameValidator.class).to(AWSS3BucketNameValidator.class);
        super.configure();
    }

    @Override
    protected RequestAuthorizeSignature providesRequestAuthorizeSignature(Injector i, int version) {
        return i.getInstance(AWSRequestAuthorizeSignatureV4.class);
    }

    @Singleton
    @Provides
    final S3Client provide(AWSS3Client in) {
        return in;
    }
}

