/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.xml;

import com.google.common.base.Supplier;
import javax.inject.Inject;
import org.jclouds.aws.ec2.domain.Spot;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.location.Region;

public class SpotHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Spot> {
    private StringBuilder currentText = new StringBuilder();
    protected final DateService dateService;
    protected final Supplier<String> defaultRegion;
    private Spot.Builder builder = Spot.builder();

    @Inject
    public SpotHandler(DateService dateService, @Region Supplier<String> defaultRegion) {
        this.dateService = dateService;
        this.defaultRegion = defaultRegion;
    }

    @Override
    public Spot getResult() {
        try {
            String region;
            String string = region = this.getRequest() == null ? null : AWSUtils.findRegionInArgsOrNull(this.getRequest());
            if (region == null) {
                region = this.defaultRegion.get();
            }
            Spot spot = this.builder.region(region).build();
            return spot;
        }
        finally {
            this.builder.clear();
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (qName.equals("instanceType")) {
            this.builder.instanceType(this.currentText.toString().trim());
        } else if (qName.equals("productDescription")) {
            this.builder.productDescription(this.currentText.toString().trim());
        } else if (qName.equals("spotPrice")) {
            this.builder.spotPrice(Float.parseFloat(this.currentText.toString().trim()));
        } else if (qName.equals("timestamp")) {
            this.builder.timestamp(this.dateService.iso8601DateOrSecondsDateParse(this.currentText.toString().trim()));
        } else if (qName.equals("availabilityZone")) {
            this.builder.availabilityZone(this.currentText.toString().trim());
        }
        this.currentText.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

