/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class ListOptions
extends BaseHttpRequestOptions {
    public static final ListOptions NONE = new ListOptions();
    private static final Collection<String> INCLUDE_META = ImmutableList.of(Integer.toString(1));

    public ListOptions token(String token) {
        this.headers.put("x-emc-token", Preconditions.checkNotNull(token, "x-emc-token"));
        return this;
    }

    public String getToken() {
        return this.getFirstHeaderOrNull("x-emc-token");
    }

    public ListOptions limit(int maxresults) {
        Preconditions.checkState(maxresults >= 0, "maxresults must be >= 0");
        Preconditions.checkState(maxresults <= 10000, "maxresults must be <= 10000");
        this.headers.put("x-emc-limit", Integer.toString(maxresults));
        return this;
    }

    public ListOptions includeMeta() {
        this.headers.replaceValues("x-emc-include-meta", INCLUDE_META);
        return this;
    }

    public boolean metaIncluded() {
        String meta = this.getFirstHeaderOrNull("x-emc-include-meta");
        return meta != null ? meta.equals("1") : false;
    }

    public Integer getLimit() {
        String maxresults = this.getFirstHeaderOrNull("x-emc-limit");
        return maxresults != null ? Integer.valueOf(maxresults) : null;
    }

    public static class Builder {
        public static ListOptions token(String token) {
            ListOptions options = new ListOptions();
            return options.token(token);
        }

        public static ListOptions includeMeta() {
            ListOptions options = new ListOptions();
            return options.includeMeta();
        }

        public static ListOptions limit(int maxKeys) {
            ListOptions options = new ListOptions();
            return options.limit(maxKeys);
        }
    }
}

