/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.common;

import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.ByteArrayUtils;
import net.schmizz.sshj.common.SSHRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityUtils.class);
    public static final String BOUNCY_CASTLE = "BC";
    public static final String SPONGY_CASTLE = "SC";
    private static String securityProvider = null;
    private static Boolean registerBouncyCastle;
    private static boolean registrationDone;

    public static boolean registerSecurityProvider(String providerClassName) {
        Provider provider = null;
        try {
            Class<?> name = Class.forName(providerClassName);
            provider = (Provider)name.newInstance();
        }
        catch (ClassNotFoundException e) {
            LOG.info("Security Provider class '{}' not found", (Object)providerClassName);
        }
        catch (InstantiationException e) {
            LOG.info("Security Provider class '{}' could not be created", (Object)providerClassName);
        }
        catch (IllegalAccessException e) {
            LOG.info("Security Provider class '{}' could not be accessed", (Object)providerClassName);
        }
        if (provider == null) {
            return false;
        }
        try {
            if (Security.getProvider(provider.getName()) == null) {
                Security.addProvider(provider);
            }
            if (securityProvider == null) {
                MessageDigest.getInstance("MD5", provider);
                KeyAgreement.getInstance("DH", provider);
                SecurityUtils.setSecurityProvider(provider.getName());
                return true;
            }
        }
        catch (NoSuchAlgorithmException e) {
            LOG.info(String.format("Security Provider '%s' does not support necessary algorithm", providerClassName), e);
        }
        catch (Exception e) {
            LOG.info(String.format("Registration of Security Provider '%s' unexpectedly failed", providerClassName), e);
        }
        return false;
    }

    public static synchronized Cipher getCipher(String transformation) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
        SecurityUtils.register();
        if (SecurityUtils.getSecurityProvider() == null) {
            return Cipher.getInstance(transformation);
        }
        return Cipher.getInstance(transformation, SecurityUtils.getSecurityProvider());
    }

    public static String getFingerprint(PublicKey key) {
        MessageDigest md5;
        try {
            md5 = SecurityUtils.getMessageDigest("MD5");
        }
        catch (GeneralSecurityException e) {
            throw new SSHRuntimeException(e);
        }
        md5.update(((Buffer.PlainBuffer)new Buffer.PlainBuffer().putPublicKey(key)).getCompactData());
        String undelimited = ByteArrayUtils.toHex(md5.digest());
        assert (undelimited.length() == 32) : "md5 contract";
        StringBuilder fp = new StringBuilder(undelimited.substring(0, 2));
        for (int i = 2; i <= undelimited.length() - 2; i += 2) {
            fp.append(":").append(undelimited.substring(i, i + 2));
        }
        return fp.toString();
    }

    public static synchronized KeyAgreement getKeyAgreement(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        SecurityUtils.register();
        if (SecurityUtils.getSecurityProvider() == null) {
            return KeyAgreement.getInstance(algorithm);
        }
        return KeyAgreement.getInstance(algorithm, SecurityUtils.getSecurityProvider());
    }

    public static synchronized KeyFactory getKeyFactory(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        SecurityUtils.register();
        if (SecurityUtils.getSecurityProvider() == null) {
            return KeyFactory.getInstance(algorithm);
        }
        return KeyFactory.getInstance(algorithm, SecurityUtils.getSecurityProvider());
    }

    public static synchronized KeyPairGenerator getKeyPairGenerator(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        SecurityUtils.register();
        if (SecurityUtils.getSecurityProvider() == null) {
            return KeyPairGenerator.getInstance(algorithm);
        }
        return KeyPairGenerator.getInstance(algorithm, SecurityUtils.getSecurityProvider());
    }

    public static synchronized Mac getMAC(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        SecurityUtils.register();
        if (SecurityUtils.getSecurityProvider() == null) {
            return Mac.getInstance(algorithm);
        }
        return Mac.getInstance(algorithm, SecurityUtils.getSecurityProvider());
    }

    public static synchronized MessageDigest getMessageDigest(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        SecurityUtils.register();
        if (SecurityUtils.getSecurityProvider() == null) {
            return MessageDigest.getInstance(algorithm);
        }
        return MessageDigest.getInstance(algorithm, SecurityUtils.getSecurityProvider());
    }

    public static synchronized String getSecurityProvider() {
        SecurityUtils.register();
        return securityProvider;
    }

    public static synchronized Signature getSignature(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        SecurityUtils.register();
        if (SecurityUtils.getSecurityProvider() == null) {
            return Signature.getInstance(algorithm);
        }
        return Signature.getInstance(algorithm, SecurityUtils.getSecurityProvider());
    }

    public static synchronized boolean isBouncyCastleRegistered() {
        SecurityUtils.register();
        return BOUNCY_CASTLE.equals(securityProvider) || SPONGY_CASTLE.equals(securityProvider);
    }

    public static synchronized void setRegisterBouncyCastle(boolean registerBouncyCastle) {
        SecurityUtils.registerBouncyCastle = registerBouncyCastle;
        registrationDone = false;
    }

    public static synchronized void setSecurityProvider(String securityProvider) {
        SecurityUtils.securityProvider = securityProvider;
        registrationDone = false;
    }

    private static void register() {
        if (!registrationDone) {
            if (securityProvider == null && (registerBouncyCastle == null || registerBouncyCastle.booleanValue())) {
                SecurityUtils.registerSecurityProvider("org.bouncycastle.jce.provider.BouncyCastleProvider");
                if (securityProvider == null && registerBouncyCastle == null) {
                    LOG.info("BouncyCastle not registered, using the default JCE provider");
                } else if (securityProvider == null) {
                    LOG.error("Failed to register BouncyCastle as the defaut JCE provider");
                    throw new SSHRuntimeException("Failed to register BouncyCastle as the defaut JCE provider");
                }
            }
            registrationDone = true;
        }
    }
}

