/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.util.Vector;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.SignerInfo;

public class SignerInfos
implements DEREncodable {
    private DERConstructedSet infos;

    public SignerInfos(Vector vector) {
        this.setInfos(vector);
    }

    public SignerInfos(DERConstructedSet dERConstructedSet) {
        this.infos = dERConstructedSet;
    }

    public SignerInfos(SignerInfos signerInfos) {
        this.infos = signerInfos.infos;
    }

    public static SignerInfos getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof SignerInfos) {
            return (SignerInfos)object;
        }
        if (object instanceof DERConstructedSet) {
            return new SignerInfos((DERConstructedSet)object);
        }
        if (object instanceof BERTaggedObject) {
            return SignerInfos.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid SignerInfos");
    }

    public static SignerInfos newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof SignerInfos) {
            return new SignerInfos((SignerInfos)object);
        }
        if (object instanceof DERConstructedSet) {
            return new SignerInfos((DERConstructedSet)object);
        }
        if (object instanceof BERTaggedObject) {
            return SignerInfos.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid SignerInfos");
    }

    public Vector getInfos() {
        int n = this.infos.getSize();
        Vector<SignerInfo> vector = new Vector<SignerInfo>();
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(SignerInfo.getInstance(this.infos.getObjectAt(n2)));
            ++n2;
        }
        return vector;
    }

    private void setInfos(Vector vector) {
        int n = vector.size();
        this.infos = new DERConstructedSet();
        int n2 = 0;
        while (n2 < n) {
            this.infos.addObject(SignerInfo.getInstance(vector.elementAt(n2)));
            ++n2;
        }
    }

    public DERObject getDERObject() {
        return this.infos;
    }
}

