/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;

public class MessageAuthenticationCode
implements DEREncodable {
    private DEROctetString mac;

    public MessageAuthenticationCode(byte[] byArray) {
        this.setMac(byArray);
    }

    public MessageAuthenticationCode(DEROctetString dEROctetString) {
        this.mac = dEROctetString;
    }

    public MessageAuthenticationCode(MessageAuthenticationCode messageAuthenticationCode) {
        this.mac = messageAuthenticationCode.mac;
    }

    public static MessageAuthenticationCode getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof MessageAuthenticationCode) {
            return (MessageAuthenticationCode)object;
        }
        if (object instanceof DEROctetString) {
            return new MessageAuthenticationCode((DEROctetString)object);
        }
        if (object instanceof BERTaggedObject) {
            return MessageAuthenticationCode.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid MessageAuthenticationCode");
    }

    public static MessageAuthenticationCode newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof MessageAuthenticationCode) {
            return new MessageAuthenticationCode((MessageAuthenticationCode)object);
        }
        if (object instanceof DEROctetString) {
            return new MessageAuthenticationCode((DEROctetString)object);
        }
        if (object instanceof BERTaggedObject) {
            return MessageAuthenticationCode.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid MessageAuthenticationCode");
    }

    public byte[] getMac() {
        return this.mac.getOctets();
    }

    private void setMac(byte[] byArray) {
        this.mac = new DEROctetString(byArray);
    }

    public DERObject getDERObject() {
        return this.mac;
    }
}

