/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.xml;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ultradns.ws.domain.Zone;
import org.jclouds.ultradns.ws.domain.ZoneProperties;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class ZonePropertiesHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<ZoneProperties> {
    private final DateService dateService;
    private ZoneProperties zone;

    @Inject
    ZonePropertiesHandler(DateService dateService) {
        this.dateService = dateService;
    }

    @Override
    public ZoneProperties getResult() {
        try {
            ZoneProperties zoneProperties = this.zone;
            return zoneProperties;
        }
        finally {
            this.zone = null;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
        if (SaxUtils.equalsOrSuffix(qName, "GeneralZoneProperties")) {
            Zone.Type type = Zone.Type.valueOf(Preconditions.checkNotNull(attributes.get("zoneType"), "zoneType").toUpperCase());
            int count = Integer.parseInt(Preconditions.checkNotNull(attributes.get("resourceRecordCount"), "resourceRecordCount"));
            this.zone = ZoneProperties.builder().name(attributes.get("name")).typeCode(type.getCode()).resourceRecordCount(count).modified(this.dateService.iso8601DateParse(attributes.get("modified"))).build();
        }
    }
}

