/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.xml;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ultradns.ws.domain.Zone;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class ZoneHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Zone> {
    private Zone zone;

    @Override
    public Zone getResult() {
        try {
            Zone zone = this.zone;
            return zone;
        }
        finally {
            this.zone = null;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
        if (SaxUtils.equalsOrSuffix(qName, "UltraZone")) {
            this.zone = Zone.builder().id(attributes.get("zoneId")).name(attributes.get("zoneName")).typeCode(Integer.parseInt(Preconditions.checkNotNull(attributes.get("zoneType"), "zoneType"))).accountId(attributes.get("accountId")).ownerId(attributes.get("owner")).dnssecStatus(Zone.DNSSECStatus.fromValue(attributes.get("dnssecStatus"))).primarySrc(attributes.get("primarySrc")).build();
        }
    }
}

