/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.xml;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ultradns.ws.domain.TrafficControllerPoolRecord;
import org.jclouds.ultradns.ws.domain.TrafficControllerPoolRecordDetail;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class TrafficControllerPoolRecordDetailListHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<FluentIterable<TrafficControllerPoolRecordDetail>> {
    private final ImmutableSet.Builder<TrafficControllerPoolRecordDetail> records = ImmutableSet.builder();

    @Override
    public FluentIterable<TrafficControllerPoolRecordDetail> getResult() {
        return FluentIterable.from(this.records.build());
    }

    @Override
    public void startElement(String url, String name, String qName, Attributes attrs) {
        if (!SaxUtils.equalsOrSuffix(qName, "PoolRecordData")) {
            return;
        }
        Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
        TrafficControllerPoolRecord record = TrafficControllerPoolRecord.create(attributes.get("recordType"), attributes.get("pointsTo"));
        this.records.add((Object)TrafficControllerPoolRecordDetail.builder().id(attributes.get("poolRecordID")).poolId(attributes.get("poolId")).record(record).weight(Integer.parseInt(Preconditions.checkNotNull(attributes.get("weight"), "weight"))).priority(Integer.parseInt(Preconditions.checkNotNull(attributes.get("priority"), "priority"))).forceAnswer(attributes.get("forceAnswer")).probingEnabled("ENABLED".equalsIgnoreCase(attributes.get("probing"))).status(TrafficControllerPoolRecordDetail.Status.valueOf(attributes.get("status"))).serving("Yes".equalsIgnoreCase(attributes.get("serving"))).description(attributes.get("description")).build());
    }
}

