/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.xml;

import java.util.Map;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ultradns.ws.domain.TrafficControllerPool;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class TrafficControllerPoolHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<TrafficControllerPool> {
    private TrafficControllerPool.Builder pool = TrafficControllerPool.builder();

    @Override
    public TrafficControllerPool getResult() {
        try {
            TrafficControllerPool trafficControllerPool = this.pool.build();
            return trafficControllerPool;
        }
        finally {
            this.pool = TrafficControllerPool.builder();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
        if (SaxUtils.equalsOrSuffix(qName, "LBPoolData")) {
            this.pool.zoneId(attributes.get("zoneid"));
        } else if (SaxUtils.equalsOrSuffix(qName, "PoolData")) {
            this.pool.id(attributes.get("PoolId")).name(attributes.get("description")).dname(attributes.get("PoolDName"));
            this.pool.statusCode(Integer.parseInt(attributes.get("PoolStatus")));
            this.pool.failOverEnabled("Enabled".equalsIgnoreCase(attributes.get("FailOver")));
            this.pool.probingEnabled("Enabled".equalsIgnoreCase(attributes.get("Probing")));
        }
    }
}

