/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.xml;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ultradns.ws.domain.ResourceRecordDetail;
import org.jclouds.ultradns.ws.xml.ResourceRecordDetailHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class ResourceRecordListHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<FluentIterable<ResourceRecordDetail>> {
    private final ResourceRecordDetailHandler resourceRecordHandler;
    private ImmutableSet.Builder<ResourceRecordDetail> rrs = ImmutableSet.builder();

    @Inject
    public ResourceRecordListHandler(ResourceRecordDetailHandler resourceRecordHandler) {
        this.resourceRecordHandler = resourceRecordHandler;
    }

    @Override
    public FluentIterable<ResourceRecordDetail> getResult() {
        return FluentIterable.from(this.rrs.build());
    }

    @Override
    public void startElement(String url, String name, String qName, Attributes attributes) {
        this.resourceRecordHandler.startElement(url, name, qName, attributes);
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (SaxUtils.equalsOrSuffix(qName, "ResourceRecord")) {
            this.rrs.add((Object)this.resourceRecordHandler.getResult());
        }
    }
}

