/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.xml;

import com.google.inject.Inject;
import java.util.Map;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ultradns.ws.domain.ResourceRecord;
import org.jclouds.ultradns.ws.domain.ResourceRecordDetail;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class ResourceRecordDetailHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<ResourceRecordDetail> {
    private final DateService dateService;
    private ResourceRecordDetail.Builder rrm = ResourceRecordDetail.builder();
    private ResourceRecord.Builder rr = ResourceRecord.rrBuilder();

    @Inject
    private ResourceRecordDetailHandler(DateService dateService) {
        this.dateService = dateService;
    }

    @Override
    public ResourceRecordDetail getResult() {
        try {
            ResourceRecordDetail resourceRecordDetail = this.rrm.record(this.rr.build()).build();
            return resourceRecordDetail;
        }
        finally {
            this.rrm = ResourceRecordDetail.builder();
            this.rr = ResourceRecord.rrBuilder();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
        if (SaxUtils.equalsOrSuffix(qName, "ResourceRecord")) {
            this.rrm.zoneId(attributes.get("ZoneId"));
            this.rrm.guid(attributes.get("Guid"));
            this.rrm.zoneName(attributes.get("ZoneName"));
            this.rrm.created(this.dateService.iso8601DateParse(attributes.get("Created")));
            this.rrm.modified(this.dateService.iso8601DateParse(attributes.get("Modified")));
            this.rr.type(Integer.parseInt(attributes.get("Type")));
            this.rr.name(attributes.get("DName"));
            this.rr.ttl(Integer.parseInt(attributes.get("TTL")));
        } else if (SaxUtils.equalsOrSuffix(qName, "InfoValues")) {
            this.rr.rdata(attributes.values());
        }
    }
}

