/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.xml;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ultradns.ws.domain.PoolRecordSpec;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class PoolRecordSpecHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<PoolRecordSpec> {
    private final PoolRecordSpec.Builder builder = PoolRecordSpec.builder();

    @Override
    public PoolRecordSpec getResult() {
        return this.builder.build();
    }

    @Override
    public void startElement(String url, String name, String qName, Attributes attrs) {
        if (!SaxUtils.equalsOrSuffix(qName, "PoolRecordSpecData")) {
            return;
        }
        Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
        this.builder.description(attributes.get("description")).state(attributes.get("recordState"));
        this.builder.probingEnabled(this.trueIfEnabled(attributes, "probing")).allFailEnabled(this.trueIfEnabled(attributes, "allFail"));
        this.builder.weight(this.asInt(attributes, "weight")).failOverDelay(this.asInt(attributes, "failOverDelay")).threshold(this.asInt(attributes, "threshold")).ttl(this.asInt(attributes, "ttl"));
    }

    private boolean trueIfEnabled(Map<String, String> attributes, String name) {
        return "ENABLED".equalsIgnoreCase(attributes.get(name));
    }

    private int asInt(Map<String, String> attributes, String name) {
        return Integer.parseInt(Preconditions.checkNotNull(attributes.get(name), name));
    }
}

