/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.jclouds.ultradns.ws.domain.PoolRecordSpec;
import org.jclouds.ultradns.ws.domain.TrafficControllerPoolRecordDetail;

public final class UpdatePoolRecord {
    private final String rdata;
    private final String mode;
    private final int priority;
    private final int weight;
    private final int failOverDelay;
    private final int threshold;
    private final int ttl;

    public static UpdatePoolRecord pointingTo(PoolRecordSpec spec, String rdata) {
        return new Builder().from(spec).rdata(rdata).build();
    }

    private UpdatePoolRecord(String rdata, String mode, int priority, int weight, int failOverDelay, int threshold, int ttl) {
        this.rdata = Preconditions.checkNotNull(rdata, "rdata");
        this.mode = Preconditions.checkNotNull(mode, "mode for %s", (Object)rdata);
        this.priority = priority;
        this.weight = weight;
        Preconditions.checkArgument(weight >= 0, "weight of %s must be >= 0", (Object)rdata);
        this.failOverDelay = failOverDelay;
        Preconditions.checkArgument(failOverDelay >= 0, "failOverDelay of %s must be >= 0", (Object)rdata);
        this.threshold = threshold;
        Preconditions.checkArgument(threshold >= 0, "threshold of %s must be >= 0", (Object)rdata);
        this.ttl = ttl;
        Preconditions.checkArgument(ttl >= 0, "ttl of %s must be >= 0", (Object)rdata);
    }

    public String getRData() {
        return this.rdata;
    }

    public String getMode() {
        return this.mode;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getFailOverDelay() {
        return this.failOverDelay;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public int getTTL() {
        return this.ttl;
    }

    public int hashCode() {
        return Objects.hashCode(this.rdata, this.mode, this.priority, this.weight, this.failOverDelay, this.threshold, this.ttl);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UpdatePoolRecord that = (UpdatePoolRecord)UpdatePoolRecord.class.cast(obj);
        return Objects.equal(this.rdata, that.rdata) && Objects.equal(this.mode, that.mode) && Objects.equal(this.priority, that.priority) && Objects.equal(this.weight, that.weight) && Objects.equal(this.failOverDelay, that.failOverDelay) && Objects.equal(this.threshold, that.threshold) && Objects.equal(this.ttl, that.ttl);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("rdata", this.rdata).add("mode", this.mode).add("priority", this.priority).add("weight", this.weight).add("failOverDelay", this.failOverDelay).add("threshold", this.threshold).add("ttl", this.ttl).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static final class Builder {
        private String rdata;
        private String mode;
        private int priority;
        private int weight;
        private int failOverDelay;
        private int threshold;
        private int ttl;

        public Builder rdata(String rdata) {
            this.rdata = rdata;
            return this;
        }

        public Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public Builder failOverDelay(int failOverDelay) {
            this.failOverDelay = failOverDelay;
            return this;
        }

        public Builder threshold(int threshold) {
            this.threshold = threshold;
            return this;
        }

        public Builder ttl(int ttl) {
            this.ttl = ttl;
            return this;
        }

        public UpdatePoolRecord build() {
            return new UpdatePoolRecord(this.rdata, this.mode, this.priority, this.weight, this.failOverDelay, this.threshold, this.ttl);
        }

        public Builder from(PoolRecordSpec in) {
            return this.mode(in.getState()).weight(in.getWeight()).failOverDelay(in.getFailOverDelay()).threshold(in.getThreshold()).ttl(in.getTTL());
        }

        public Builder from(TrafficControllerPoolRecordDetail in) {
            return this.weight(in.getWeight()).rdata(in.getRecord().getRData()).priority(in.getPriority());
        }

        public Builder from(UpdatePoolRecord in) {
            return this.rdata(in.rdata).mode(in.mode).priority(in.priority).weight(in.weight).failOverDelay(in.failOverDelay).threshold(in.threshold).ttl(in.ttl);
        }
    }
}

