/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.jclouds.ultradns.ws.domain.ResourceRecord;

public class ResourceRecordDetail {
    private final String zoneId;
    private final String guid;
    private final String zoneName;
    private final Date created;
    private final Date modified;
    private final ResourceRecord record;

    private ResourceRecordDetail(String zoneId, String guid, String zoneName, Date created, Date modified, ResourceRecord record) {
        this.zoneId = Preconditions.checkNotNull(zoneId, "zoneId");
        this.guid = Preconditions.checkNotNull(guid, "guid");
        this.zoneName = Preconditions.checkNotNull(zoneName, "zoneName of %s/%s", (Object)zoneId, (Object)guid);
        this.created = Preconditions.checkNotNull(created, "created of %s/%s", (Object)zoneId, (Object)guid);
        this.modified = Preconditions.checkNotNull(modified, "modified of %s/%s", (Object)zoneId, (Object)guid);
        this.record = Preconditions.checkNotNull(record, "record of %s/%s", (Object)zoneId, (Object)guid);
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public String getGuid() {
        return this.guid;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getModified() {
        return this.modified;
    }

    public ResourceRecord getRecord() {
        return this.record;
    }

    public int hashCode() {
        return Objects.hashCode(this.zoneId, this.guid);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceRecordDetail that = (ResourceRecordDetail)ResourceRecordDetail.class.cast(obj);
        return Objects.equal(this.zoneId, that.zoneId) && Objects.equal(this.guid, that.guid);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("zoneId", this.zoneId).add("guid", this.guid).add("zoneName", this.zoneName).add("created", this.created).add("modified", this.modified).add("record", this.record).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ResourceRecordDetail.builder().from(this);
    }

    public static final class Builder {
        private String zoneId;
        private String guid;
        private String zoneName;
        private Date created;
        private Date modified;
        private ResourceRecord record;

        public Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public Builder guid(String guid) {
            this.guid = guid;
            return this;
        }

        public Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder modified(Date modified) {
            this.modified = modified;
            return this;
        }

        public Builder record(ResourceRecord record) {
            this.record = record;
            return this;
        }

        public Builder record(ResourceRecord.Builder record) {
            this.record = record.build();
            return this;
        }

        public ResourceRecordDetail build() {
            return new ResourceRecordDetail(this.zoneId, this.guid, this.zoneName, this.created, this.modified, this.record);
        }

        public Builder from(ResourceRecordDetail in) {
            return this.zoneName(in.zoneName).guid(in.guid).zoneId(in.zoneId).created(in.created).modified(in.modified).record(in.record);
        }
    }
}

