/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.domain;

import com.google.common.base.Functions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;

public class ResourceRecord {
    private final String dName;
    private final int type;
    private final int ttl;
    private final List<String> infoValues;

    private ResourceRecord(String dName, int type, int ttl, List<String> infoValues) {
        this.dName = Preconditions.checkNotNull(dName, "dName");
        Preconditions.checkArgument(type >= 0, "type of %s must be >= 0", (Object)dName);
        this.type = type;
        Preconditions.checkArgument(ttl >= 0, "ttl of %s must be >= 0", (Object)dName);
        this.ttl = ttl;
        this.infoValues = Preconditions.checkNotNull(infoValues, "infoValues of %s", (Object)dName);
    }

    public String getName() {
        return this.dName;
    }

    public int getType() {
        return this.type;
    }

    public int getTTL() {
        return this.ttl;
    }

    public List<String> getRData() {
        return this.infoValues;
    }

    public int hashCode() {
        return Objects.hashCode(this.dName, this.type, this.ttl, this.infoValues);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceRecord that = (ResourceRecord)ResourceRecord.class.cast(obj);
        return Objects.equal(this.dName, that.dName) && Objects.equal(this.type, that.type) && Objects.equal(this.ttl, that.ttl) && Objects.equal(this.infoValues, that.infoValues);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("dName", this.dName).add("type", this.type).add("ttl", this.ttl).add("infoValues", this.infoValues).toString();
    }

    public static Builder rrBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ResourceRecord.rrBuilder().from(this);
    }

    public static final class Builder {
        private String dName;
        private int type = -1;
        private int ttl = -1;
        private ImmutableList.Builder<String> infoValues = ImmutableList.builder();

        public Builder name(String dName) {
            this.dName = dName;
            return this;
        }

        public Builder type(int type) {
            this.type = type;
            return this;
        }

        public Builder ttl(int ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder infoValue(Object infoValue) {
            this.infoValues.add((Object)infoValue.toString());
            return this;
        }

        public Builder rdata(Object infoValue) {
            this.infoValues = ImmutableList.builder().add(infoValue.toString());
            return this;
        }

        public Builder rdata(Iterable<?> infoValues) {
            this.infoValues = ImmutableList.builder().addAll(Iterables.transform(infoValues, Functions.toStringFunction()));
            return this;
        }

        public ResourceRecord build() {
            return new ResourceRecord(this.dName, this.type, this.ttl, (List)((Object)this.infoValues.build()));
        }

        public Builder from(ResourceRecord in) {
            return this.name(in.getName()).type(in.getType()).ttl(in.getTTL()).rdata(in.getRData());
        }
    }
}

