/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class DirectionalGroupCoordinates {
    private final String zoneName;
    private final String recordName;
    private final int recordType;
    private final String groupName;

    private DirectionalGroupCoordinates(String zoneName, String recordName, int recordType, String groupName) {
        this.zoneName = Preconditions.checkNotNull(zoneName, "zoneName");
        this.recordName = Preconditions.checkNotNull(recordName, "recordName");
        Preconditions.checkArgument(recordType >= 0, "recordType of %s must be >= 0", (Object)recordName);
        this.recordType = recordType;
        this.groupName = Preconditions.checkNotNull(groupName, "groupName");
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public String getRecordName() {
        return this.recordName;
    }

    public int getRecordType() {
        return this.recordType;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public int hashCode() {
        return Objects.hashCode(this.zoneName, this.recordName, this.recordType, this.groupName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DirectionalGroupCoordinates that = (DirectionalGroupCoordinates)DirectionalGroupCoordinates.class.cast(obj);
        return Objects.equal(this.zoneName, that.zoneName) && Objects.equal(this.recordName, that.recordName) && Objects.equal(this.recordType, that.recordType) && Objects.equal(this.groupName, that.groupName);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("zoneName", this.zoneName).add("recordName", this.recordName).add("recordType", this.recordType).add("groupName", this.groupName).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return DirectionalGroupCoordinates.builder().from(this);
    }

    public static final class Builder {
        private String zoneName;
        private String recordName;
        private int recordType = -1;
        private String groupName;

        public Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public Builder recordName(String recordName) {
            this.recordName = recordName;
            return this;
        }

        public Builder recordType(int recordType) {
            this.recordType = recordType;
            return this;
        }

        public Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public DirectionalGroupCoordinates build() {
            return new DirectionalGroupCoordinates(this.zoneName, this.recordName, this.recordType, this.groupName);
        }

        public Builder from(DirectionalGroupCoordinates in) {
            return this.zoneName(in.zoneName).recordName(in.zoneName).recordType(in.recordType).groupName(in.groupName);
        }
    }
}

