/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sts.options;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Multimap;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class SessionCredentialsOptions
extends BaseHttpRequestOptions
implements Cloneable {
    private Long durationSeconds;
    private String tokenCode;
    private String serialNumber;

    public SessionCredentialsOptions serialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    public SessionCredentialsOptions durationSeconds(long durationSeconds) {
        this.durationSeconds = durationSeconds;
        return this;
    }

    public SessionCredentialsOptions tokenCode(String tokenCode) {
        this.tokenCode = tokenCode;
        return this;
    }

    @Override
    public Multimap<String, String> buildFormParameters() {
        Multimap<String, String> params = super.buildFormParameters();
        if (this.serialNumber != null) {
            params.put("SerialNumber", this.serialNumber.toString());
        }
        if (this.durationSeconds != null) {
            params.put("DurationSeconds", this.durationSeconds.toString());
        }
        if (this.tokenCode != null) {
            params.put("TokenCode", this.tokenCode);
        }
        return params;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.serialNumber, this.durationSeconds, this.tokenCode);
    }

    public SessionCredentialsOptions clone() {
        return new SessionCredentialsOptions().serialNumber(this.serialNumber).durationSeconds(this.durationSeconds).tokenCode(this.tokenCode);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SessionCredentialsOptions other = (SessionCredentialsOptions)SessionCredentialsOptions.class.cast(obj);
        return Objects.equal(this.serialNumber, other.serialNumber) && Objects.equal(this.durationSeconds, other.durationSeconds) && Objects.equal(this.tokenCode, other.tokenCode);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("serialNumber", this.serialNumber).add("durationSeconds", this.durationSeconds).add("tokenCode", this.tokenCode).toString();
    }

    public static class Builder {
        public static SessionCredentialsOptions serialNumber(String serialNumber) {
            return new SessionCredentialsOptions().serialNumber(serialNumber);
        }

        public static SessionCredentialsOptions durationSeconds(long durationSeconds) {
            return new SessionCredentialsOptions().durationSeconds(durationSeconds);
        }

        public static SessionCredentialsOptions tokenCode(String tokenCode) {
            return new SessionCredentialsOptions().tokenCode(tokenCode);
        }
    }
}

