/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sshj;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.google.common.net.HostAndPort;
import com.google.inject.Inject;
import com.jcraft.jsch.agentproxy.Connector;
import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.inject.Named;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.connection.channel.direct.SessionChannel;
import net.schmizz.sshj.sftp.RemoteFile;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.sftp.SFTPException;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.xfer.InMemorySourceFile;
import org.jclouds.compute.domain.ExecChannel;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.logging.Logger;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.ssh.SshClient;
import org.jclouds.ssh.SshException;
import org.jclouds.ssh.SshKeys;
import org.jclouds.sshj.SSHClientConnection;
import org.jclouds.util.Closeables2;
import org.jclouds.util.Throwables2;

public class SshjSshClient
implements SshClient {
    private final String toString;
    @Inject(optional=true)
    @Named(value="jclouds.ssh.max-retries")
    @VisibleForTesting
    int sshRetries = 5;
    @Inject(optional=true)
    @Named(value="jclouds.ssh.retry-auth")
    @VisibleForTesting
    boolean retryAuth;
    @Inject(optional=true)
    @Named(value="jclouds.ssh.retryable-messages")
    @VisibleForTesting
    String retryableMessages = "";
    @Inject(optional=true)
    @Named(value="jclouds.ssh.retry-predicate")
    private Predicate<Throwable> retryPredicate = Predicates.or(Predicates.instanceOf(ConnectionException.class), Predicates.instanceOf(ConnectException.class), Predicates.instanceOf(SocketTimeoutException.class), Predicates.instanceOf(TransportException.class), Predicates.instanceOf(SFTPException.class));
    @Resource
    @Named(value="jclouds.ssh")
    protected Logger logger = Logger.NULL;
    @VisibleForTesting
    SSHClientConnection sshClientConnection;
    final String user;
    final String host;
    private final BackoffLimitedRetryHandler backoffLimitedRetryHandler;
    Connection<SFTPClient> sftpConnection = new Connection<SFTPClient>(){
        private SFTPClient sftp;

        @Override
        public void clear() {
            if (this.sftp != null) {
                try {
                    this.sftp.close();
                }
                catch (IOException e) {
                    Throwables.propagate(e);
                }
            }
        }

        @Override
        public SFTPClient create() throws IOException {
            SshjSshClient.this.checkConnected();
            this.sftp = SshjSshClient.this.sshClientConnection.ssh.newSFTPClient();
            return this.sftp;
        }

        public String toString() {
            return "SFTPClient()";
        }
    };

    public SshjSshClient(BackoffLimitedRetryHandler backoffLimitedRetryHandler, HostAndPort socket, LoginCredentials loginCredentials, int timeout, Optional<Connector> agentConnector) {
        this.user = Preconditions.checkNotNull(loginCredentials, "loginCredentials").getUser();
        this.host = Preconditions.checkNotNull(socket, "socket").getHost();
        Preconditions.checkArgument(socket.getPort() > 0, "ssh port must be greater then zero" + socket.getPort());
        Preconditions.checkArgument(loginCredentials.getOptionalPassword().isPresent() || loginCredentials.hasUnencryptedPrivateKey() || agentConnector.isPresent(), "you must specify a password, a key or an SSH agent needs to be available");
        this.backoffLimitedRetryHandler = Preconditions.checkNotNull(backoffLimitedRetryHandler, "backoffLimitedRetryHandler");
        if (loginCredentials.hasUnencryptedPrivateKey()) {
            String fingerPrint = SshKeys.fingerprintPrivateKey(loginCredentials.getOptionalPrivateKey().get());
            String sha1 = SshKeys.sha1PrivateKey(loginCredentials.getOptionalPrivateKey().get());
            this.toString = String.format("%s:rsa[fingerprint(%s),sha1(%s)]@%s:%d", loginCredentials.getUser(), fingerPrint, sha1, this.host, socket.getPort());
        } else {
            this.toString = loginCredentials.getOptionalPassword().isPresent() ? String.format("%s:pw[%s]@%s:%d", loginCredentials.getUser(), BaseEncoding.base16().lowerCase().encode(Hashing.md5().hashString(loginCredentials.getOptionalPassword().get(), Charsets.UTF_8).asBytes()), this.host, socket.getPort()) : String.format("%s:rsa[ssh-agent]@%s:%d", loginCredentials.getUser(), this.host, socket.getPort());
        }
        this.sshClientConnection = SSHClientConnection.builder().hostAndPort(HostAndPort.fromParts(this.host, socket.getPort())).loginCredentials(loginCredentials).connectTimeout(timeout).sessionTimeout(timeout).agentConnector(agentConnector).build();
    }

    @Override
    public void put(String path, String contents) {
        this.put(path, Payloads.newStringPayload(Preconditions.checkNotNull(contents, "contents")));
    }

    private void checkConnected() {
        Preconditions.checkState(this.sshClientConnection.ssh != null && this.sshClientConnection.ssh.isConnected(), "(%s) ssh not connected!", (Object)this);
    }

    private void backoffForAttempt(int retryAttempt, String message) {
        this.backoffLimitedRetryHandler.imposeBackoffExponentialDelay(200L, 2, retryAttempt, this.sshRetries, message);
    }

    protected <T, C extends Connection<T>> T acquire(C connection) {
        String errorMessage = String.format("(%s) error acquiring %s", this.toString(), connection);
        for (int i = 0; i < this.sshRetries; ++i) {
            try {
                connection.clear();
                this.logger.debug(">> (%s) acquiring %s", this.toString(), connection);
                T returnVal = connection.create();
                this.logger.debug("<< (%s) acquired %s", this.toString(), returnVal);
                return returnVal;
            }
            catch (Exception from) {
                try {
                    this.disconnect();
                }
                catch (Exception e1) {
                    this.logger.warn(from, "<< (%s) error closing connection", this.toString());
                }
                if (i + 1 == this.sshRetries) {
                    throw this.propagate(from, errorMessage + " (out of retries - max " + this.sshRetries + ")");
                }
                if (this.shouldRetry(from) || Throwables2.getFirstThrowableOfType(from, IllegalStateException.class) != null) {
                    this.logger.info("<< " + errorMessage + " (attempt " + (i + 1) + " of " + this.sshRetries + "): " + from.getMessage(), new Object[0]);
                    this.backoffForAttempt(i + 1, errorMessage + ": " + from.getMessage());
                    if (connection == this.sshClientConnection) continue;
                    this.connect();
                    continue;
                }
                throw this.propagate(from, errorMessage + " (not retryable)");
            }
        }
        throw new AssertionError((Object)"should not reach here");
    }

    @Override
    public void connect() {
        try {
            this.acquire(this.sshClientConnection);
        }
        catch (Exception e) {
            Throwables.propagate(e);
        }
    }

    @Override
    public Payload get(String path) {
        return (Payload)this.acquire(new GetConnection(path));
    }

    @Override
    public void put(String path, Payload contents) {
        this.acquire(new PutConnection(path, contents));
    }

    @VisibleForTesting
    boolean shouldRetry(Exception from) {
        Predicate<Throwable> predicate;
        Predicate<Throwable> predicate2 = predicate = this.retryAuth ? Predicates.or(this.retryPredicate, Predicates.instanceOf(AuthorizationException.class), Predicates.instanceOf(UserAuthException.class)) : this.retryPredicate;
        if (Iterables.any(Throwables.getCausalChain(from), predicate)) {
            return true;
        }
        if (!this.retryableMessages.equals("")) {
            return Iterables.any(Splitter.on(",").split(this.retryableMessages), this.causalChainHasMessageContaining(from));
        }
        return false;
    }

    @VisibleForTesting
    Predicate<String> causalChainHasMessageContaining(final Exception from) {
        return new Predicate<String>(){

            @Override
            public boolean apply(final String input) {
                return Iterables.any(Throwables.getCausalChain(from), new Predicate<Throwable>(){

                    @Override
                    public boolean apply(Throwable arg0) {
                        return arg0.toString().indexOf(input) != -1 || arg0.getMessage() != null && arg0.getMessage().indexOf(input) != -1;
                    }
                });
            }
        };
    }

    @VisibleForTesting
    SshException propagate(Exception e, String message) {
        message = message + ": " + e.getMessage();
        this.logger.error(e, "<< " + message, new Object[0]);
        if (e instanceof UserAuthException) {
            throw new AuthorizationException("(" + this.toString() + ") " + message, e);
        }
        throw e instanceof SshException ? (SshException)SshException.class.cast(e) : new SshException("(" + this.toString() + ") " + message, e);
    }

    public String toString() {
        return this.toString;
    }

    @Override
    @PreDestroy
    public void disconnect() {
        try {
            this.sshClientConnection.clear();
        }
        catch (Exception e) {
            Throwables.propagate(e);
        }
    }

    @Override
    public boolean isConnected() {
        try {
            return this.sshClientConnection.getSSHClient().isConnected();
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    protected Connection<Session> execConnection() {
        return new Connection<Session>(){
            private Session session = null;

            @Override
            public void clear() throws TransportException, ConnectionException {
                if (this.session != null) {
                    this.session.close();
                }
            }

            @Override
            public Session create() throws Exception {
                SshjSshClient.this.checkConnected();
                this.session = SshjSshClient.this.sshClientConnection.ssh.startSession();
                this.session.allocatePTY("vt100", 80, 24, 0, 0, ImmutableMap.of());
                return this.session;
            }

            public String toString() {
                return "Session()";
            }
        };
    }

    @Override
    public ExecResponse exec(String command) {
        return (ExecResponse)this.acquire(new ExecConnection(command));
    }

    protected Connection<Session> noPTYConnection() {
        return new Connection<Session>(){
            private Session session = null;
            private SSHClient sshClientConnection;

            @Override
            public void clear() throws TransportException, ConnectionException {
                if (this.session != null) {
                    this.session.close();
                }
                if (this.sshClientConnection != null) {
                    Closeables2.closeQuietly(this.sshClientConnection);
                }
            }

            @Override
            public Session create() throws Exception {
                this.sshClientConnection = (SSHClient)SshjSshClient.this.acquire(SSHClientConnection.builder().fromSSHClientConnection(SshjSshClient.this.sshClientConnection).sessionTimeout(0).build());
                this.session = this.sshClientConnection.startSession();
                return this.session;
            }

            public String toString() {
                return "Session()";
            }
        };
    }

    @Override
    public ExecChannel execChannel(String command) {
        return (ExecChannel)this.acquire(new ExecChannelConnection(command));
    }

    @Override
    public String getHostAddress() {
        return this.host;
    }

    @Override
    public String getUsername() {
        return this.user;
    }

    class ExecChannelConnection
    implements Connection<ExecChannel> {
        private final String command;
        private Session.Command output;
        private Connection<Session> connection;

        ExecChannelConnection(String command) {
            this.command = Preconditions.checkNotNull(command, "command");
        }

        @Override
        public void clear() {
            Closeables2.closeQuietly(this.output);
            try {
                if (this.connection != null) {
                    this.connection.clear();
                }
            }
            catch (Throwable e) {
                Throwables.propagate(e);
            }
        }

        @Override
        public ExecChannel create() throws Exception {
            this.connection = SshjSshClient.this.noPTYConnection();
            this.output = ((SessionChannel)SessionChannel.class.cast(SshjSshClient.this.acquire(this.connection))).exec(this.command);
            return new ExecChannel(this.output.getOutputStream(), this.output.getInputStream(), this.output.getErrorStream(), new Supplier<Integer>(){

                @Override
                public Integer get() {
                    return ExecChannelConnection.this.output.getExitStatus();
                }
            }, new Closeable(){

                @Override
                public void close() throws IOException {
                    ExecChannelConnection.this.clear();
                }
            });
        }

        public String toString() {
            return "ExecChannel(command=[" + this.command + "])";
        }
    }

    class ExecConnection
    implements Connection<ExecResponse> {
        private final String command;
        private Session session;

        ExecConnection(String command) {
            this.command = Preconditions.checkNotNull(command, "command");
        }

        @Override
        public void clear() throws TransportException, ConnectionException {
            if (this.session != null) {
                this.session.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ExecResponse create() throws Exception {
            try {
                this.session = (Session)SshjSshClient.this.acquire(SshjSshClient.this.execConnection());
                Session.Command output = this.session.exec(Preconditions.checkNotNull(this.command, "command"));
                String outputString = IOUtils.readFully(output.getInputStream()).toString();
                output.join(SshjSshClient.this.sshClientConnection.getSessionTimeout(), TimeUnit.MILLISECONDS);
                String errorString = IOUtils.readFully(output.getErrorStream()).toString();
                ExecResponse execResponse = new ExecResponse(outputString, errorString, output.getExitStatus());
                return execResponse;
            }
            finally {
                this.clear();
            }
        }

        public String toString() {
            return "ExecResponse(command=[" + this.command + "])";
        }
    }

    class PutConnection
    implements Connection<Void> {
        private final String path;
        private final Payload contents;
        private SFTPClient sftp;

        PutConnection(String path, Payload contents) {
            this.path = Preconditions.checkNotNull(path, "path");
            this.contents = Preconditions.checkNotNull(contents, "contents");
        }

        @Override
        public void clear() {
            if (this.sftp != null) {
                try {
                    this.sftp.close();
                }
                catch (IOException e) {
                    Throwables.propagate(e);
                }
            }
        }

        @Override
        public Void create() throws Exception {
            this.sftp = (SFTPClient)SshjSshClient.this.acquire(SshjSshClient.this.sftpConnection);
            try {
                this.sftp.put(new InMemorySourceFile(){

                    @Override
                    public String getName() {
                        return PutConnection.this.path;
                    }

                    @Override
                    public long getLength() {
                        Long length = PutConnection.this.contents.getContentMetadata().getContentLength();
                        return length != null ? length : -1L;
                    }

                    @Override
                    public InputStream getInputStream() throws IOException {
                        return Preconditions.checkNotNull(PutConnection.this.contents.getInput(), "inputstream for path %s", (Object)PutConnection.this.path);
                    }
                }, this.path);
            }
            finally {
                this.contents.release();
            }
            return null;
        }

        public String toString() {
            return "Put(path=[" + this.path + "])";
        }
    }

    class GetConnection
    implements Connection<Payload> {
        private final String path;
        private SFTPClient sftp;

        GetConnection(String path) {
            this.path = Preconditions.checkNotNull(path, "path");
        }

        @Override
        public void clear() throws IOException {
            if (this.sftp != null) {
                this.sftp.close();
            }
        }

        @Override
        public Payload create() throws Exception {
            RemoteFile remoteFile;
            this.sftp = (SFTPClient)SshjSshClient.this.acquire(SshjSshClient.this.sftpConnection);
            RemoteFile remoteFile2 = remoteFile = this.sftp.getSFTPEngine().open(this.path);
            Objects.requireNonNull(remoteFile2);
            RemoteFile.RemoteFileInputStream in = new RemoteFile.RemoteFileInputStream(remoteFile2){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        remoteFile.close();
                    }
                }
            };
            return Payloads.newInputStreamPayload(new CloseFtpChannelOnCloseInputStream(in, this.sftp));
        }

        public String toString() {
            return "Payload(path=[" + this.path + "])";
        }
    }

    public static interface Connection<T> {
        public void clear() throws Exception;

        public T create() throws Exception;
    }

    private static final class CloseFtpChannelOnCloseInputStream
    extends FilterInputStream {
        private final SFTPClient sftp;

        private CloseFtpChannelOnCloseInputStream(InputStream proxy, SFTPClient sftp) {
            super(proxy);
            this.sftp = sftp;
        }

        @Override
        public void close() throws IOException {
            super.close();
            if (this.sftp != null) {
                this.sftp.close();
            }
        }
    }
}

