/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingList;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.scriptbuilder.domain.AcceptsStatementVisitor;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementVisitor;

public class StatementList
extends ForwardingList<Statement>
implements Statement,
AcceptsStatementVisitor {
    public final List<Statement> statements;

    public StatementList(Statement ... statements) {
        this.statements = ImmutableList.copyOf(Preconditions.checkNotNull(statements, "statements"));
    }

    public StatementList(Iterable<Statement> statements) {
        this.statements = ImmutableList.copyOf(Preconditions.checkNotNull(statements, "statements"));
    }

    @Override
    public String render(OsFamily family) {
        StringBuilder statementsBuilder = new StringBuilder();
        for (Statement statement : this.delegate()) {
            statementsBuilder.append(statement.render(family));
        }
        return statementsBuilder.toString();
    }

    @Override
    public Iterable<String> functionDependencies(OsFamily family) {
        ImmutableList.Builder functions = ImmutableList.builder();
        for (Statement statement : this.delegate()) {
            functions.addAll(statement.functionDependencies(family));
        }
        return functions.build();
    }

    @Override
    public void accept(StatementVisitor visitor) {
        for (Statement statement : this.delegate()) {
            visitor.visit(statement);
        }
    }

    @Override
    public List<Statement> delegate() {
        return this.statements;
    }
}

