/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.binders;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.hash.Hashing;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.StringPayload;
import org.jclouds.rest.Binder;
import org.jclouds.s3.binders.XMLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BindIterableAsPayloadToDeleteRequest
implements Binder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        String content;
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input is null") instanceof Iterable, "this binder is only valid for an Iterable");
        Preconditions.checkNotNull(request, "request is null");
        Iterable keys = (Iterable)input;
        Preconditions.checkArgument(!Iterables.isEmpty(keys), "The list of keys should not be empty.");
        try {
            Document document = XMLHelper.createDocument();
            Element rootNode = XMLHelper.elem(document, "Delete", document);
            for (String key : keys) {
                Element objectNode = XMLHelper.elem(rootNode, "Object", document);
                XMLHelper.elemWithText(objectNode, "Key", key, document);
            }
            content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + XMLHelper.asString(document);
        }
        catch (ParserConfigurationException | TransformerException pce) {
            throw Throwables.propagate(pce);
        }
        StringPayload payload = Payloads.newStringPayload(content);
        payload.getContentMetadata().setContentType("text/xml");
        byte[] md5 = Hashing.md5().hashString(content, Charsets.UTF_8).asBytes();
        payload.getContentMetadata().setContentMD5(md5);
        request.setPayload(payload);
        return request;
    }
}

